// Плагин является частичной копи-пастой с макросов

document.addEventListener("DOMContentLoaded", function() {
    const styleTheme = document.createElement('style');
    styleTheme.type = 'text/css';

    window.lockTooltipsPosition = true;
    const editorElem = document.getElementById("editorWrapper");
    const rules = ".Ace-Tern-tooltip {\
    box-sizing: border-box;\
    max-width: " + editorElem.offsetWidth + "px !important;\
    min-width: " + editorElem.offsetWidth + "px !important;\
    left: " + editorElem.offsetLeft + "px !important;\
    bottom: " + parseInt(document.getElementsByClassName("divFooter")[0].offsetHeight) + "px !important;\
    }";

    styleTheme.innerHTML = rules;
    document.getElementsByTagName('head')[0].appendChild(styleTheme);
});

const editor = ace.edit("editor");
editor.session.setMode("ace/mode/javascript");
editor.setValue("");


editor.getSession().setUseWrapMode(true);
editor.getSession().setWrapLimitRange(null, null);
editor.setShowPrintMargin(false);
editor.$blockScrolling = Infinity;

ace.config.loadModule('ace/ext/tern', function () {
    editor.setOptions({
        enableTern: {
            defs: ['browser', 'ecma5'],
            plugins: { doc_comment: { fullDocs: true } },
            useWorker: !!window.Worker,            
            switchToDoc: function (name, start) {},            
            startedCb: function () {},
        }, 
        enableSnippets: false,
        enableBasicAutocompletion: true,
    });
});

ace.config.loadModule('ace/ext/html_beautify', function (beautify) {
    editor.setOptions({
        autoBeautify: true,
        htmlBeautify: true,
    });
    window.beautifyOptions = beautify.options;
});

(function(window, undefined){
    let isShowRename = false;
    let data = {
        userFunctionsArray : [],
        current : -1
    };

    function createGuid(a,b) {
       for(b=a='';a++<36;b+=a*51&52?(a^15?8^Math.random()*(a^20?16:4):4).toString(16):'');
       return b
    }

    function onItemClick(index, isAttack) {
        if (index !== data.current || isAttack) {
            for (let i = 0; i < data.userFunctionsArray.length; i++) {
                const elem = document.getElementById(`item${i}`);
                if (i === index) {
                    elem.classList.remove("userFunction");
                    elem.classList.add("userFunction-selected");
                } else if (i === data.current) {
                    elem.classList.remove("userFunction-selected");
                    elem.classList.add("userFunction");
                }
            }
            data.current = index;
        }

        if (-1 === data.current) {
            window.isDisable = true;
            editor.setValue('');
            editor.setReadOnly(true);
            window.isDisable = false;
        } else {
            window.isDisable = true;
            editor.setValue(data.userFunctionsArray[index].value);
            editor.setReadOnly(false);
            window.isDisable = false;
            editor.focus();
        }
        editor.selection.clearSelection();
    }

    function updateScrollMenu() {
        Ps = new PerfectScrollbar("#menu", {});
        Ps.update();
    }

    function updateMenu() {
        if (data.current < 0) {
            data.current = 0;
        }

        if (data.current >= data.userFunctionsArray.length) {
            data.current = data.userFunctionsArray.length - 1;
        }
            
        let menuContent = "";
        for (let i = 0; i < data.userFunctionsArray.length; i++) {
            const className = (i === data.current) ? "userFunction-selected" : "userFunction";
            const name = $('<div/>').text(data.userFunctionsArray[i].name).html();
            const item = `<div class=${className} id=item${i} onclick='onItemClick(${i})'>${name}</div>`;
            menuContent += item;

            if (!data.userFunctionsArray[i]["guid"]) {
                data.userFunctionsArray[i]["guid"] = createGuid();
            }
        }
        
        const elem = document.getElementById("menu_content");
        elem.innerHTML = menuContent;
        
        onItemClick(data.current, true);
        updateScrollMenu();
    }

    function addEventsToButtons() {
        document.getElementById("button_new").onclick = function() {
            let indexMax = 0;
            const firstName = 'FN_';

            for (let i = 0; i < data.userFunctionsArray.length; i++) {
                if (!data.userFunctionsArray[i].name.indexOf(firstName)) {
                    const index = parseInt(data.userFunctionsArray[i].name.substr(firstName.length));
                    if (!isNaN(index) && (indexMax < index))
                        indexMax = index;
                }
            }

            indexMax++;

            const template = "return function myFunction(first, second) {\n\n\treturn first + second;\n}"
            data.userFunctionsArray.push({
                name : (firstName + indexMax),
                value : template
            });

            data.current = data.userFunctionsArray.length - 1;
            updateMenu();
            editor.focus();
        };

        document.getElementById("button_delete").onclick = function() {
            if (data.current !== -1) {
                data.userFunctionsArray.splice(data.current, 1);
                updateMenu();
            }
        };

        document.getElementById("button_rename").onclick = function() {
            showRename();
        };

        document.getElementById("rename_ok").onclick = function() {
            unShowRename(true);
        };

        document.getElementById("rename_cancel").onclick = function() {
            unShowRename(false);
        };

        document.addEventListener("keydown", async (event) => {
            if ( (event.ctrlKey || event.metaKey) && event.key.toLowerCase() === 's') {
                event.preventDefault();
                event.stopPropagation();

                if (!isShowRename) {
                    startAction();
                    const problematicFunction = await getProblematicFunction();
                    updateErrorTimeMessage(problematicFunction);
                    endAction();

                    if (problematicFunction) {
                        return;
                    }

                    window.Asc.plugin.executeMethod("SetUserFunctionsRawData", [JSON.stringify(data)],  () => {
                        window.Asc.plugin.executeMethod("ReloadFormulasList");
                    });
                }
            }
        }, false);

        document.addEventListener("keyup", function(event) {
            if ( (event.ctrlKey || event.metaKey) && event.key.toLowerCase() === 's') {
                event.preventDefault();
                event.stopPropagation();
            }
        }, false);

        document.getElementById("button_run").onclick = async function() {
            if (data.current !== -1) {
                const currentFunction = data.userFunctionsArray[data.current];
                startAction();
                const result = await checkExecuteTime(currentFunction.value);
                endAction();

                if (result) {
                    updateErrorTimeMessage();
                } else {
                    updateErrorTimeMessage(currentFunction);
                    return;
                }

                window.Asc.plugin.executeCommand("command", `${new Function(`${currentFunction.value}`)()}`);
            }
        };

        const textbox = document.getElementById("rename_text");
        // clear validation on input/paste
        textbox.oninput = textbox.onpaste = function(e) {
            this.style.borderColor = "";
            document.getElementById("input_error_id").style.display = "none";
        };
        // ie
        textbox.addEventListener("paste", function(e) {
            this.style.borderColor = "";
            document.getElementById("input_error_id").style.display = "none";
        });
    }

    function addEventsToWindow() {
        window.onItemClick = onItemClick;

        window.onresize = function() {
            updateScrollMenu();
        }

        window.onkeydown = function(e) {
            if (isShowRename) {
                switch (e.keyCode) {
                    case 27:
                        unShowRename(false);
                        break;
                    case 13:
                        unShowRename(true);
                        break;
                    default:
                        break;
                }
            }
        }
    }

    function addEventsToEditor() {
        editor.getSession().on('change', function() {

            if (data.current === -1 || window.isDisable) {
                return;
            }

            data.userFunctionsArray[data.current].value = editor.getValue();
        });
    }

    function showRename() {
        if (data.current < 0) {
            return;
        }

        const renameMask = document.getElementById("idRenameMask");
        const rename = document.getElementById("idRename");
        renameMask.style.display = "block";
        rename.style.display = "block";
        const [, functionName] = data.userFunctionsArray[data.current].name.split('_')
        document.getElementById("rename_text").value = functionName;
        document.getElementById("rename_text").select();

        isShowRename = true;
    }

    function unShowRename(isOK) {
        const value = document.getElementById("rename_text").value;

        if ((isOK && value) || !isOK) {
            const renameMask = document.getElementById("idRenameMask");
            const rename = document.getElementById("idRename");
            renameMask.style.display = "none";
            rename.style.display = "none";
            document.getElementById("input_error_id").style.display = "none";
            document.getElementById("rename_text").style.borderColor = "#cfcfcf";
            isShowRename = false;
        }
        

        if (data.current < 0) {
            return;
        }

        if (isOK && value) {
            const [prefix] = data.userFunctionsArray[data.current].name.split('_')
            data.userFunctionsArray[data.current].name = `${prefix}_${value}`;
            updateMenu();
        } else if (isOK && !value) {
            document.getElementById("input_error_id").style.display = "block";
            document.getElementById("rename_text").style.borderColor = "#d9534f";
        }

        value.value = "";
    }

    async function checkExecuteTime(value, timeout = 5000) {
        try {
            const workerCode = `   
                const fn = ${new Function(`${value}`)()};
                const isAsync = fn.constructor.name === 'AsyncFunction';
                
                const handleResult = (result) => {
                    self.postMessage({ result });
                };
                
                const handleError = (error) => {
                    self.postMessage({ error: error.message || String(error) });
                };
                
                try {
                    if (isAsync) {
                        fn().then(handleResult).catch(handleError);
                    } else {
                        handleResult(fn());
                    }
                } catch (err) {
                    handleError(err);
                }
        `;

            const blob = new Blob([workerCode], { type: "application/javascript" });
            const worker = new Worker(URL.createObjectURL(blob));

            return new Promise((resolve) => {
                const timer = setTimeout(() => {
                    worker.terminate();
                    resolve(false);
                }, timeout);

                worker.onmessage = () => {
                    clearTimeout(timer);
                    resolve(true);
                    worker.terminate();
                };

                worker.onerror = () => {
                    clearTimeout(timer);
                    resolve(true);
                    worker.terminate();
                };
            });
        } catch {
            return true;
        }
    }

    function updateErrorTimeMessage(problematicFunction) {
        const errorArea = document.getElementById("error_area");

        if (problematicFunction) {
            const functionText = window.Asc.plugin.tr("Function");
            const functionLongerText = window.Asc.plugin.tr("runs longer than 5 seconds");
            errorArea.textContent = `${functionText}: ${problematicFunction.name} ${functionLongerText}.`
        } else {
            errorArea.textContent = '';
        }
    }
    
    async function getProblematicFunction () {
        if (!data.userFunctionsArray.length) {
            return;
        }

        let problematicFunction;

        for (let functionData of data.userFunctionsArray) {
            const result = await checkExecuteTime(functionData.value);
            if (!result) {
                problematicFunction = functionData;
                break;
            }
        }

        return problematicFunction;
    }

    function startAction() {
        const c_oAscAsyncActionWaiting = 18;
        window.Asc.plugin.executeMethod("StartAction", ['Block', c_oAscAsyncActionWaiting]);
    }

    function endAction() {
        const c_oAscAsyncActionWaiting = 18;
        window.Asc.plugin.executeMethod("EndAction", ['Block', c_oAscAsyncActionWaiting]);
    }

    window.Asc.plugin.init = async function() {
        addEventsToButtons();
        addEventsToWindow();
        updateScrollMenu();
        addEventsToEditor();
        window.Asc.plugin.resizeWindow(undefined, undefined, 400, 300, 0, 0);

        this.executeMethod("GetUserFunctionsRawData", [JSON.stringify(data)], function(rawData) {
            try {
                data = JSON.parse(rawData);
            } catch (err) {
                data = {
                    userFunctionsArray : [],
                    current : -1
                };
                document.getElementById("button_new").onclick();
            }

            updateMenu();
        });
	};
	
	window.Asc.plugin.button = async function(idButton) {
        if (idButton) {
            return this.executeCommand("close", "");
        }

        startAction();
        const problematicFunction = await getProblematicFunction();
        updateErrorTimeMessage(problematicFunction);
        endAction();

        if (problematicFunction) {
            return;
        }

        this.executeMethod("SetUserFunctionsRawData", [JSON.stringify(data)],  () => {
            this.executeMethod("ReloadFormulasList");
            window.Asc.plugin.executeCommand("close", "");
        });

    };
    
    window.Asc.plugin.onExternalMouseUp = function() {
        const evt = document.createEvent("MouseEvents");
        evt.initMouseEvent("mouseup", true, true, window, 1, 0, 0, 0, 0,
            false, false, false, false, 0, null);

        document.dispatchEvent(evt);
    };
	
	window.Asc.plugin.onTranslate = function() {
		document.getElementById("button_new").textContent = window.Asc.plugin.tr("New");
		document.getElementById("button_delete").textContent = window.Asc.plugin.tr("Delete");
        document.getElementById("button_rename").textContent = window.Asc.plugin.tr("Rename");
        document.getElementById("button_run").textContent = window.Asc.plugin.tr("Run");
        document.getElementById("rename_ok").textContent = window.Asc.plugin.tr("Ok");
        document.getElementById("rename_cancel").textContent = window.Asc.plugin.tr("Cancel");
        document.getElementById("input_error_id").title = window.Asc.plugin.tr("Title");
    };

    window.Asc.plugin.onThemeChanged = function(theme) {
        window.Asc.plugin.onThemeChangedBase(theme);
        $('#menu_content, .ace_content').css('background', window.Asc.plugin.theme["background-normal"]);
        $('#menu_content, .ace_content').css('color', window.Asc.plugin.theme["text-normal"]);
        $('.ace_layer.ace_gutter-layer.ace_folding-enabled').css('background', window.Asc.plugin.theme["background-toolbar"]);
        $('.ace_layer.ace_gutter-layer.ace_folding-enabled').css('color', window.Asc.plugin.theme["text-normal"]);
        $('#menu, .divFooter').css('border-color', window.Asc.plugin.theme["border-divider"]);
        $('.ace_scroller').css('border-left', 'solid 0.73px ' + window.Asc.plugin.theme["border-divider"]);
        $('.ace_cursor').css('color', window.Asc.plugin.theme["text-normal"]);
        $('#menu').css('background-color', window.Asc.plugin.theme["background-normal"]);
        $('#idRename').css('background-color', window.Asc.plugin.theme["background-toolbar"]);
        $('#idRename').css('border-color', window.Asc.plugin.theme["border-toolbar-button-hover"]);

        let rules = '.userFunction { color: ' + window.Asc.plugin.theme["text-normal"] + '; background-color: ' + window.Asc.plugin.theme['background-toolbar'] + '}\n';
        rules += '.userFunction:hover { background-color: ' + window.Asc.plugin.theme['highlight-button-hover'] + '}\n';
        rules += '.userFunction-selected { background-color: ' + window.Asc.plugin.theme['highlight-button-pressed'] + '}\n';

        if (theme.type === 'dark') {
            rules += '.ace-chrome .ace_marker-layer .ace_selected-word { background: rgb(250, 250, 255, 0.3) !important; border: 1px solid rgb(200, 200, 250); }'
        } else {
            rules += '.ace-chrome .ace_marker-layer .ace_selected-word { background: rgb(255, 255, 255); border: 1px solid rgb(200, 200, 250); }'
        }

        let styleTheme = document.createElement('style');
        styleTheme.type = 'text/css';
        styleTheme.innerHTML = rules;
        document.getElementsByTagName('head')[0].appendChild(styleTheme);


        if (theme.type === 'dark') {
            editor.setTheme("ace/theme/vs-dark")
        } else {
            editor.setTheme("ace/theme/vs-light")
        }

    };

})(window, undefined);