#!/bin/bash

DB_HOST=$(grep -oP "host=[^\";]*" /etc/dovecot/dovecot-mysql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_USER=$(grep -oP "user=[^\";]*" /etc/dovecot/dovecot-mysql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PASS=$(grep -oP "password=[^\";]*" /etc/dovecot/dovecot-mysql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_NAME=$(grep -oP "dbname=[^\";]*" /etc/dovecot/dovecot-mysql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)

SOURCE=$(echo "$1" | tr '[:upper:]' '[:lower:]')
DESTINATIONS=$(echo "$2" | tr '[:upper:]' '[:lower:]')

# Извлекаем домен из исходного адреса
DOMAIN=$(echo "$SOURCE" | awk -F'@' '{print $2}')

# Получаем ID домена из таблицы virtual_domains
DOMAIN_ID=$(mysql -u$DB_USER -p$DB_PASS $DB_NAME -s -N -e "SELECT id FROM virtual_domains WHERE name='$DOMAIN'")

if [ -z "$DOMAIN_ID" ]; then
    echo "Домен не найден"
    exit 1
fi

# Преобразование списка адресов назначения в массив
IFS=',' read -ra DEST_ARR <<< "$DESTINATIONS"

# Добавление новых алиасов для каждого адреса назначения
for DEST in "${DEST_ARR[@]}"; do
    mysql -u$DB_USER -p$DB_PASS $DB_NAME -e "INSERT INTO virtual_aliases (domain_id, source, destination) VALUES ('$DOMAIN_ID', '$SOURCE', '$DEST')"
done

# Проверка выполнения всех запросов и вывод соответствующего сообщения
if [ $? -eq 0 ]; then
    echo "Алиасы успешно добавлены"
else
    echo "Ошибка добавления алиасов"
fi