#!/bin/bash

HAVE_ERROR="false"

CDDISK_NAME=$(debconf-show cddisk | grep /cddisk-name | cut -d ':' -f 2 | tr -d ' ')
echo "CDDISK_NAME=$CDDISK_NAME"
ADMIN_NAME=$(debconf-show cddisk | grep /admin-name | cut -d ':' -f 2 | tr -d ' ')
echo "ADMIN_NAME=$ADMIN_NAME"
if [ -f cddisk-calendar*.deb ] && [ -f cdmail*.deb ]; then
    CDMAIL_NAME=$(debconf-show cddisk | grep /cdmail-name | cut -d ':' -f 2 | tr -d ' ')
    echo "CDMAIL_NAME=$CDMAIL_NAME"
    CALENDAR_NAME=$(debconf-show cddisk | grep /calendar-name | cut -d ':' -f 2 | tr -d ' ')
    echo "CALENDAR_NAME=$CALENDAR_NAME"
fi
CONTACTS_NAME=$(debconf-show cddisk | grep /contacts-name | cut -d ':' -f 2 | tr -d ' ')
echo "CONTACTS_NAME=$CONTACTS_NAME"
PROJECTS_NAME=$(debconf-show cddisk | grep /projects-name | cut -d ':' -f 2 | tr -d ' ')
echo "PROJECTS_NAME=$PROJECTS_NAME"
PAGES_NAME=$(debconf-show cddisk | grep /pages-name | cut -d ':' -f 2 | tr -d ' ')
echo "PAGES_NAME=$PAGES_NAME"
FORMS_NAME=$(debconf-show cddisk | grep /forms-name | cut -d ':' -f 2 | tr -d ' ')
echo "FORMS_NAME=$FORMS_NAME"
LOCAL_SITE_DOMAIN=$(debconf-show cddisk | grep /site-domain | cut -d ':' -f 2 | tr -d ' ')
echo "LOCAL_SITE_DOMAIN=$LOCAL_SITE_DOMAIN"
LOCAL_DS_EXTERNAL=$(debconf-show cddisk | grep /ds-external | cut -d ':' -f 2 | tr -d ' ')
echo "LOCAL_DS_EXTERNAL=$LOCAL_DS_EXTERNAL"
MAKE_HTTPS=$(debconf-show cddisk | grep /make-https | cut -d ':' -f 2 | tr -d ' ')
echo "MAKE_HTTPS=$MAKE_HTTPS"

echo "Проверка сервисов, которые неактивны или не включены при запуске."

if [ $LOCAL_DS_EXTERNAL = "true" ]; then
    DSLIST="supervisor postgresql rabbitmq-server redis nginx"
else
    DSLIST="supervisor postgresql rabbitmq-server redis nginx ds-metrics.service ds-docservice.service ds-converter.service"
fi

for name in $DSLIST; do
    isActive=$(systemctl is-active ${name})
    isEnabled=$(systemctl is-enabled ${name})
    if [ "$isActive" == "inactive" ] || [ "$isEnabled" == "disabled" ]; then
	echo "Сервис: ${name}"
	echo "  Активность: $isActive"
	echo "  Автозапуск: $isEnabled"
	HAVE_ERROR="true"
	echo -e "\e[31m❌ Ошибка  \e[0m"
    else
	echo -e "Сервис: ${name} \e[32m OK \e[0m"
    fi
done

echo "Проверка программ, которые неактивны или не включены при запуске."

for name in cddisk:api cddisk:apisso cddisk:filestorage cddisk:processing cddisk:registry cddisk:searchapi; do
    status=$(supervisorctl status ${name} | awk '{print $2}')
    if [ "$status" != "RUNNING" ]; then
	echo "Программа: ${name}"
	echo "  Статус: $status"
	HAVE_ERROR="true"
	echo -e "\e[31m❌ Ошибка  \e[0m"
    else
	echo -e "Программа: ${name} \e[32m OK \e[0m"
    fi
done

echo "Проверка записей в файле /etc/hosts."
if [ -f cddisk-calendar*.deb ] && [ -f cdmail*.deb ]; then
for name in ${LOCAL_SITE_DOMAIN} $CDDISK_NAME.${LOCAL_SITE_DOMAIN} $ADMIN_NAME.${LOCAL_SITE_DOMAIN} $CDMAIL_NAME.${LOCAL_SITE_DOMAIN} $CALENDAR_NAME.${LOCAL_SITE_DOMAIN} $CONTACTS_NAME.${LOCAL_SITE_DOMAIN} $PROJECTS_NAME.${LOCAL_SITE_DOMAIN}; do
    isHostsPresent=$(cat /etc/hosts | grep "127.0.0.1 ${name}")
    if [ "$isHostsPresent" == "" ]; then
	echo "Запись \"${name}\" отсутствует в /etc/hosts"
	HAVE_ERROR="true"
	echo -e "\e[31m❌ Ошибка  \e[0m"
    else
	echo -e "Запись \"${name}\" \e[32m OK \e[0m"
    fi
done
else
for name in ${LOCAL_SITE_DOMAIN} $CDDISK_NAME.${LOCAL_SITE_DOMAIN} $ADMIN_NAME.${LOCAL_SITE_DOMAIN} $CONTACTS_NAME.${LOCAL_SITE_DOMAIN} $PROJECTS_NAME.${LOCAL_SITE_DOMAIN}; do
    isHostsPresent=$(cat /etc/hosts | grep "127.0.0.1 ${name}")
    if [ "$isHostsPresent" == "" ]; then
	echo "Запись \"${name}\" отсутствует в /etc/hosts"
	HAVE_ERROR="true"
	echo -e "\e[31m❌ Ошибка  \e[0m"
    else
	echo -e "Запись \"${name}\" \e[32m OK \e[0m"
    fi
done
fi
base_domain=$LOCAL_SITE_DOMAIN

if [ -f cddisk-calendar*.deb ] && [ -f cdmail*.deb ]; then
sites=(
"$ADMIN_NAME.$base_domain"
"$CDDISK_NAME.$base_domain"
"$CALENDAR_NAME.$base_domain"
"$CDMAIL_NAME.$base_domain"
"$CONTACTS_NAME.$base_domain"
"$PROJECTS_NAME.$base_domain"
)
else
sites=(
"$ADMIN_NAME.$base_domain"
"$CDDISK_NAME.$base_domain"
"$CONTACTS_NAME.$base_domain"
"$PROJECTS_NAME.$base_domain"
)
fi

for site in "${sites[@]}"; do
if [ $MAKE_HTTPS = "true" ]; then
    response_code=$(curl -o /dev/null -s -w "%{http_code}" "https://$site")
else
    response_code=$(curl -o /dev/null -s -w "%{http_code}" "http://$site")
fi
    if [[ $response_code -eq 200 ]]; then
        echo "Сайт $site успешно открывается."
    else
        echo "Сайт $site не открывается или возвращает код ошибки: $response_code"
        HAVE_ERROR="true"
    echo -e "\e[31m❌ Ошибка  \e[0m"
    fi
done

#metrics converter docservice 
if [ $MAKE_HTTPS = "true" ]; then
if [ -f cddisk-calendar*.deb ] && [ -f cdmail*.deb ]; then
endpoints=(
"https://$CDDISK_NAME.$base_domain/api/v1/version"
"https://$ADMIN_NAME.$base_domain/api/v1/version"
"https://$CDMAIL_NAME.$base_domain/api/v1/version"
"https://$CALENDAR_NAME.$base_domain/api/v1/version"
"https://$CONTACTS_NAME.$base_domain/api/v1/version"
"https://$PROJECTS_NAME.$base_domain/api/v1/version"
)
else
endpoints=(
"https://$CDDISK_NAME.$base_domain/api/v1/version"
"https://$ADMIN_NAME.$base_domain/api/v1/version"
"https://$CONTACTS_NAME.$base_domain/api/v1/version"
"https://$PROJECTS_NAME.$base_domain/api/v1/version"
)
fi
else
if [ -f cddisk-calendar*.deb ] && [ -f cdmail*.deb ]; then
endpoints=(
"http://$CDDISK_NAME.$base_domain/api/v1/version"
"http://$ADMIN_NAME.$base_domain/api/v1/version"
"http://$CDMAIL_NAME.$base_domain/api/v1/version"
"http://$CALENDAR_NAME.$base_domain/api/v1/version"
"http://$CONTACTS_NAME.$base_domain/api/v1/version"
"http://$PROJECTS_NAME.$base_domain/api/v1/version"
)
else
endpoints=(
"http://$CDDISK_NAME.$base_domain/api/v1/version"
"http://$ADMIN_NAME.$base_domain/api/v1/version"
"http://$CONTACTS_NAME.$base_domain/api/v1/version"
"http://$PROJECTS_NAME.$base_domain/api/v1/version"
)
fi
fi

for endpoint in "${endpoints[@]}"; do
    echo "Проверка $endpoint ..."
    
    response=$(curl -s "$endpoint")

    # Проверка на наличие ошибок в запросе
    if [[ $? -eq 0 ]]; then
        version=$(echo $response | /opt/r7-office/installtools/json Version)
        name=$(echo $response | /opt/r7-office/installtools/json Name)
        copyright=$(echo $response | /opt/r7-office/installtools/json Copyrigth)
        
        echo "Имя: $name"
        echo "Версия: $version"
        echo "Авторские права: $copyright"
        if [ -z "${oldname}" ] && [ -z "${oldversion}" ] && [ -z "${oldcopyright}" ] ; then
            oldname="${name}"
            oldversion="${version}"
            oldcopyright="${copyright}"
        else
            if [ "${oldname}" != "${name}" ];then
            echo "Не совпадает имя ${oldname} != ${name}"
	HAVE_ERROR="true"
	echo -e "\e[31m❌ Ошибка  \e[0m"
            fi
            if [ "${oldversion}" != "${version}" ];then
            echo "Не совпадает версия ${oldversion} != ${version}"
	HAVE_ERROR="true"
	echo -e "\e[31m❌ Ошибка  \e[0m"
            fi
            if [ "${oldcopyright}" != "${copyright}" ];then
            echo "Не совпадает версия ${oldcopyright} != ${copyright}"
	HAVE_ERROR="true"
	echo -e "\e[31m❌ Ошибка  \e[0m"
            fi
        fi
    else
        echo "Ошибка при доступе к $endpoint"
        HAVE_ERROR="true"
    echo -e "\e[31m❌ Ошибка  \e[0m"
    fi
    echo "---------------------------"
done

# Определите папки для проверки
if [ $LOCAL_DS_EXTERNAL = "true" ]; then
    directories=(
"/var/log/r7-office/CDDisk/Api"
"/var/log/r7-office/CDDisk/FileStorage"
"/var/log/r7-office/CDDisk/Processing"
"/var/log/r7-office/CDDisk/R7.Storage.Server.Api.Host"
"/var/log/r7-office/CDDisk/SearchApi"
"/var/log/r7-office/CDDisk/R7.Storage.Server.Processing.Host"
"/var/log/r7-office/CDDisk/Service.Registry"
"/var/log/nginx"
"/var/log/rabbitmq"
"/var/log/redis"
"/var/log/supervisor"
    )
else
    directories=(
"/var/log/r7-office/documentserver/converter"
"/var/log/r7-office/documentserver/docservice"
"/var/log/r7-office/documentserver/metrics"
"/var/log/r7-office/CDDisk/Api"
"/var/log/r7-office/CDDisk/FileStorage"
"/var/log/r7-office/CDDisk/Processing"
"/var/log/r7-office/CDDisk/R7.Storage.Server.Api.Host"
"/var/log/r7-office/CDDisk/SearchApi"
"/var/log/r7-office/CDDisk/R7.Storage.Server.Processing.Host"
"/var/log/r7-office/CDDisk/Service.Registry"
"/var/log/nginx"
"/var/log/rabbitmq"
"/var/log/redis"
"/var/log/supervisor"
    )
fi

for dir in "${directories[@]}"; do
    # Проверка существования папки
    if [[ -d $dir ]]; then
        echo "Папка $dir существует."

        # Проверка на наличие лог-файлов в папке
        log_files=($(find $dir -type f -name "*.log"))
        if [[ ${#log_files[@]} -gt 0 ]]; then
            echo "Лог-файлы в $dir:"
            for log in "${log_files[@]}"; do
                echo "  $log"
            done
        else
            echo "В папке $dir лог-файлы отсутствуют."
            HAVE_ERROR="true"
        echo -e "\e[31m❌ Ошибка  \e[0m"
        fi
    else
        echo "Папка $dir не существует!"
        HAVE_ERROR="true"
    echo -e "\e[31m❌ Ошибка  \e[0m"
    fi
done

if [ $HAVE_ERROR = "true" ]; then
echo -e "\e[31m❌ Ошибка  \e[0m"
echo "-----------------------------------------"
echo "|                                       |"
echo "|  Если возникла ошибка или нужна       |"
echo "|  помощь, обратитесь:                  |"
echo "|  support@r7-office.ru                 |"
echo "|                                       |"
echo "|  С уважением к Вам,                   |"
echo "|  Команда Р7                           |"
echo "|                                       |"
echo "-----------------------------------------"
echo -e "Логин и пароль администратора \e[32msuperadmin  superadmin \e[0m"
echo -e "Чтобы получить доступ откройте в браузере:"
if [ $MAKE_HTTPS = "true" ]; then
    echo -e "Админ: \e[32mhttps://$ADMIN_NAME.$base_domain\e[0m"
    echo -e "Диск: \e[32mhttps://$CDDISK_NAME.$base_domain\e[0m"
    if [ -f cddisk-calendar*.deb ] && [ -f cdmail*.deb ]; then
	echo -e "Календарь: \e[32mhttps://$CALENDAR_NAME.$base_domain\e[0m"
	echo -e "Почта: \e[32mhttps://$CDMAIL_NAME.$base_domain\e[0m"
    fi
    echo -e "Контакты: \e[32mhttps://$CONTACTS_NAME.$base_domain\e[0m"
    echo -e "Проекты: \e[32mhttps://$PROJECTS_NAME.$base_domain\e[0m"
    echo -e "Страницы: \e[32mhttps://$PAGES_NAME.$base_domain\e[0m"
    echo -e "Формы: \e[32mhttps://$FORMS_NAME.$base_domain\e[0m"
else
    echo -e "Админ: \e[32mhttp://$ADMIN_NAME.$base_domain\e[0m"
    echo -e "Диск: \e[32mhttp://$CDDISK_NAME.$base_domain\e[0m"
    if [ -f cddisk-calendar*.deb ] && [ -f cdmail*.deb ]; then
	echo -e "Календарь: \e[32mhttp://$CALENDAR_NAME.$base_domain\e[0m"
	echo -e "Почта: \e[32mhttp://$CDMAIL_NAME.$base_domain\e[0m"
    fi
    echo -e "Контакты: \e[32mhttp://$CONTACTS_NAME.$base_domain\e[0m"
    echo -e "Проекты: \e[32mhttp://$PROJECTS_NAME.$base_domain\e[0m"
fi
echo "-----------------------------------------"
else
echo -e "\n\e[32m✅ Установка прошла успешно  \e[0m"
echo "-----------------------------------------"
echo "|                                       |"
echo "|  Если возникла ошибка или нужна       |"
echo "|  помощь, обратитесь:                  |"
echo "|  support@r7-office.ru                 |"
echo "|                                       |"
echo "|  С уважением к Вам,                   |"
echo "|  Команда Р7                           |"
echo "|                                       |"
echo "-----------------------------------------"
echo -e "Логин и пароль администратора \e[32msuperadmin  superadmin \e[0m"
echo -e "Чтобы получить доступ откройте в браузере:"
if [ $MAKE_HTTPS = "true" ]; then
    echo -e "Админ: \e[32mhttps://$ADMIN_NAME.$base_domain\e[0m"
    echo -e "Диск: \e[32mhttps://$CDDISK_NAME.$base_domain\e[0m"
    if [ -f cddisk-calendar*.deb ] && [ -f cdmail*.deb ]; then
	echo -e "Календарь: \e[32mhttps://$CALENDAR_NAME.$base_domain\e[0m"
	echo -e "Почта: \e[32mhttps://$CDMAIL_NAME.$base_domain\e[0m"
    fi
    echo -e "Контакты: \e[32mhttps://$CONTACTS_NAME.$base_domain\e[0m"
    echo -e "Проекты: \e[32mhttps://$PROJECTS_NAME.$base_domain\e[0m"
    echo -e "Страницы: \e[32mhttps://$PAGES_NAME.$base_domain\e[0m"
    echo -e "Формы: \e[32mhttps://$FORMS_NAME.$base_domain\e[0m"
else
    echo -e "Админ: \e[32mhttp://$ADMIN_NAME.$base_domain\e[0m"
    echo -e "Диск: \e[32mhttp://$CDDISK_NAME.$base_domain\e[0m"
    if [ -f cddisk-calendar*.deb ] && [ -f cdmail*.deb ]; then
	echo -e "Календарь: \e[32mhttp://$CALENDAR_NAME.$base_domain\e[0m"
	echo -e "Почта: \e[32mhttp://$CDMAIL_NAME.$base_domain\e[0m"
    fi
    echo -e "Контакты: \e[32mhttp://$CONTACTS_NAME.$base_domain\e[0m"
    echo -e "Проекты: \e[32mhttp://$PROJECTS_NAME.$base_domain\e[0m"
fi
echo "-----------------------------------------"
fi
