### Установка сервера и веб-приложения

Требования к окружению:
- Ubuntu 16.04LTS, Ubuntu 18.04LTS, Ubuntu 20.04LTS, Ubuntu 22.04LTS, Debian 11, Debian 12, Astra Linux 1.7.4

Убедиться что соединение с сетью интернет стабильно.

- сделать исполняемым скрипт `online_installer.sh` командой `chmod +x online_installer.sh`
- запустить скрипт командой `sudo ./online_installer.sh`
- на запрос пароля для `sudo` ввести его

Если требуется поддержка HTTPS, перед установкой скопируйте crt и key файлы в папку sslcert. Имя файла должно содержать название домена и расширение.
Например, для домена yandex.ru имена файлов долдны быть yandex.ru.crt и yandex.ru.key.

Внимание!!! Во время чистой установки удаляется postgresql server вместе с базами, document server, cddisk, cdmail, calendar и conatcts вместе с содержимым.
В процессе установки требуется ввод пользователя:
Если требуется выполнить чистую установку, то в диалоге
- Настраивается cddisk "Make clean install?": Выбрать Да (Yes)
Если не требуется выполнить чистую установку, то в диалоге
- Настраивается cddisk "Make clean install?": Выбрать Нет (No)
Для установки базы данных на локальный компьютер:
- Настраивается cddisk "Install postgresql server on local pc?": Выбрать Да (Yes)
Для установки Document Server на локальной машине, в диалоге
- Настраивается cddisk "Install Document Server?": Выбрать Да (Yes)
- Настраивается cddisk "Document Server secret:" ввести секретный ключ, выбрать *Ok*
- Настраивается cddisk "Document Server Database password:" ввести **saSA123$**, выбрать *Ok*
Если Document Server не будет установливаться в локальной машине, в диалоге
- Настраивается cddisk "Install Document Server?": Выбрать Нет (No)
- Настраивается cddisk "Document server URL:" ввести URL где установлен Document Server, выбрать *Ok*
- Настраивается cddisk "Document Server JWT key:" ввести секретный ключ установленного Document Server, выбрать *Ok*
Для установки CDDisk, в диалоге
- Настраивается cddisk "Install CDDisk api & web?": Выбрать Да (Yes)
- Настраивается cddisk "Create database": Выбрать Да (Yes)
- Настраивается cddisk "Database host": ввести имя домена куда устанавливается база данных *Ok* (по-умолчанию *localhost*)
- Настраивается cddisk "Database port": ввести tcp порт базы данных *Ok* (по-умолчанию *5432*)
- Настраивается cddisk "Database name": ввести имя пользователя, под которым будет работать база данных *Ok* (по-умолчанию *postgres*)
- Настраивается cddisk "Database user for create DB": ввести имя пользователя, под которым будет работать база данных *Ok* (по-умолчанию *postgres*)
- Настраивается cddisk "Database user": ввести имя пользователя, под которым будет работать база данных *Ok* (по-умолчанию *cddisk*)
- Настраивается cddisk "Database password for create DB:" два раза ввести **saSA123$** выбрать *Ok*
- Настраивается cddisk "Database password for user:" два раза ввести **saSA123$** выбрать *Ok*
- Настраивается cddisk "The salt to be used during the key derivation process:" ввести ключ, который будет использоваться для генерации хэшей паролей *Ok* (по-умолчанию *Vskoproizvolny Salt par Chivreski_*)
- Настраивается cddisk "Make https access to site. Make https?": Выбрать Yes или No
- Настраивается cddisk "Domain name:" ввести имя домена куда устанавливается cddisk *Ok* (по-умолчанию *local.ru*)
- Настраивается cddisk "Prefix name:" ввести префикс *Ok* (по-умолчанию *cddisk*, значение не может быть *admin*, *cdmail* или *calendar*)
- Настраивается cddisk "Prefix name for cddisk:" ввести префикс *Ok* (по-умолчанию *cddisk*, значение не может быть *admin*, *contacts*, *cdmail*, *projects* или *calendar*)
- Настраивается cddisk "Prefix name for admin:" ввести префикс *Ok* (по-умолчанию *admin*, значение не может быть *cddisk*, *contacts*, *cdmail*, *projects* или *calendar*)
- Настраивается cddisk "Prefix name for contacts:" ввести префикс *Ok* (по-умолчанию *contacts*, значение не может быть *admin*, *cddisk*, *cdmail*, *projects* или *calendar*)
- Настраивается cddisk "Prefix name for projects:" ввести префикс *Ok* (по-умолчанию *projects*, значение не может быть *admin*, *cddisk*, *contacts*, *cdmail* или *calendar*)
- Настраивается cddisk "Prefix name for cdmail:" ввести префикс *Ok* (по-умолчанию *cdmail*, значение не может быть *admin*, *contacts*, *cddisk*. *projects* или *calendar*)
- Настраивается cddisk "Prefix name for calendar:" ввести префикс *Ok* (по-умолчанию *calendar*, значение не может быть *admin*, *contacts*, *cdmail*, *projects* или *cddisk*)
- Настраивается cddisk "Prefix name for DS:" ввести префикс *Ok* (по-умолчанию *ds*)


Дождаться завершения установки. После завершения установки будет запущена проверка результатов установки.
- Лог установки записывается в файл logfile.txt в текущем каталоге
- Если установили https для проверки откройте https://cddisk.local.ru, если ввели домен отличный от дефолтного то https://cddisk.вашдомен, который ввели в переменную "Site domain"
- Если установили https для http://cddisk.local.ru, если ввели домен отличный от дефолтного то http://cddisk.вашдомен, который ввели в переменную "Site domain"
- Аналогично http(s)://cddisk.{вашдомен} http(s)://calendar.{вашдомен} http(s)://admin.{вашдомен} http(s)://cdmail.{вашдомен}
- Если авторизация не работает в браузере посмотреть ответ от api нажав кнопку F12, если 502 то выполнить команду sudo supervisorctl restart cddisk:*, если при выполнение возникли ошибки, то проверить логи /var/log/r7-office/
- Если в логах EACCES то выполнить команду chmod 755 /opt/r7-office, выполнить команду sudo supervisorctl restart cddisk:*, в случае успешного старта всех сервисов выполнить запрос по url https://cddisk.вашдомен/api/v1/version 


После проверки возможно установить почтовый сервер.

Перед установкой желательно заранее прописать записи в DNS для работы почтового сервера.
Необходимо добавить запись А (mx.your-domain.ru) и обратную запись, а также запись MX и TXT v=spf1 +mx ~all
Пример:
MX    devr7.ru                    TTL         Приоритет
      mx1.devr7.ru                300         10
TXT   devr7.ru                    TTL
      v=spf1+mx~all               300
A     mx1.devr7.ru                TTL
      185.10186.166               300

Для установки почтового сервера в диалоге
- "Установить Р7 Почтовый сервер?": Выбрать Да (Yes)
- "Введите название mx записи:": ввести имя mx записи, *Ok* (по-умолчанию *mx*)
- "Введите IP-адрес почтового сервера:": ввести IP-адрес почтового сервера, *Ok*
Предполагается, что пользователь укажет IP-адрес почтового сервера, если отправит письма во вне необходимости внешнего наблюдения.
Если почтовый сервер организации используется только внутри, то можно указать внутренний IP-адрес. Заносится в /etc/hosts
- "Введите пароль для root в почтовой БД MariaDB:" ввести пароль, *Ok*
Для хранения учетных записей и работы с почтовой картой используется БД MariaDB.
В целях безопасности пользователь должен ввести на данном этапе пароль от root MariaDB, пакет которого будет установлен во время выполнения скрипта.
- "Введите пароль для постфикса в почтовой БД MariaDB:" ввести пароль постфикса в почтовой БД MariaDB, *Ok*
Почтовый сервер всегда будет подключаться от имени пользователя postfix, на этом этапе задается пароль. При выполнении скрипта также будет внесено все необходимые файлы.

Если требуется произвести настройку спам-системы, в диалоге:
- "Установка SpamAssassin": выбрать "Установка SpamAssassin".
Если в соседнем регионе хранится антивирус со своей спам-системой, то лучше отказаться от установки и в диалоге:
- "Установка SpamAssassin": выбрать "Не устанавливать SpamAssassin".

Если требуется установить почту письма OpenDKIM, в диалоге:
- "Установить OpenDKIM?": Выбрать Да (Yes)
При согласовании будут установлены необходимые пакеты, а также будет произведена адаптация почтового сервера для работы службы.
Инструмент используется при настройке почтового сервера для работы с внешними условиями. Если почтовый сервер организация планирует использовать внутри, пакет можно не хранить.
Также в конце выполнения скрипта после завершения его работы в терминале будет выведен ключ для записи dkim, чтобы пользователь мог внести его в свой DNS.

Особенности установки почтового сервера:
- В процессе установки требуется доступ к ресурсу download.r7-office.ru, так как на нем лежит пакет Redos для ОС для установки spamassassin (требуется только в случае повтора ОС !!!)
- На данный момент при использовании Астра Линукс 1.7 необходимо в клиентах использовать шифрование SSL/TLS, использование шифрования STARTLS не соответствует данной ОС.


Варианты установки

1. Установка на локальную машину.

Если требуется поддержка HTTPS, перед установкой скопируйте crt и key файлы в папку sslcert. Имя файла должно содержать название домена и расширение.
Если требуется выполнить чистую установку, то в диалоге
- Настраивается cddisk "Make clean install?": Выбрать Да (Yes)
Если не требуется выполнить чистую установку, то в диалоге
- Настраивается cddisk "Make clean install?": Выбрать Нет (No)
- Настраивается cddisk "Install postgresql on local pc?": Выбрать Да (Yes)
- Настраивается cddisk "Install Document Server?": Выбрать Да (Yes)
- Настраивается cddisk "Document Server secret:" ввести секретный ключ, выбрать *Ok*
- Настраивается cddisk "Document Server Database password:" ввести **saSA123$**, выбрать *Ok*
- Настраивается cddisk "Install CDDisk api & web?": Выбрать Да (Yes)
- Настраивается cddisk "Create database": Выбрать Да (Yes)
- Настраивается cddisk "Database host": оставить *localhost*, выбрать *Ok*
- Настраивается cddisk "Database port": оставить *5432*, выбрать *Ok*
- Настраивается cddisk "Database name": оставить *cddisk*, выбрать *Ok*
- Настраивается cddisk "Database user for create DB": оставить *postgres*, выбрать *Ok*
- Настраивается cddisk "Database password for create DB:", ввести **saSA123$**, выбрать *Ok*
- Настраивается cddisk "Database password for user:", ввести **saSA123$**, выбрать *Ok*
- Настраивается cddisk "The salt to be used during the key derivation process:" ввести ключ, который будет использоваться для генерации хэшей паролей *Ok* (по-умолчанию *Vskoproizvolny Salt par Chivreski_*)
- Настраивается cddisk "Make https access to site. Make https?": Выбрать Yes или No
- Настраивается cddisk "Domain name:" ввести имя домена куда устанавливается cddisk *Ok* (по-умолчанию *local.ru*)
- Настраивается cddisk "Prefix name:" ввести префикс *Ok* (по-умолчанию *cddisk*, значение не может быть *admin*, *cdmail* или *calendar*)
- Настраивается cddisk "Prefix name for cddisk:" ввести префикс *Ok* (по-умолчанию *cddisk*, значение не может быть *admin*, *contacts*, *cdmail*, *projects* или *calendar*)
- Настраивается cddisk "Prefix name for admin:" ввести префикс *Ok* (по-умолчанию *admin*, значение не может быть *cddisk*, *contacts*, *cdmail*, *projects* или *calendar*)
- Настраивается cddisk "Prefix name for contacts:" ввести префикс *Ok* (по-умолчанию *contacts*, значение не может быть *admin*, *cddisk*, *cdmail*, *projects* или *calendar*)
- Настраивается cddisk "Prefix name for projects:" ввести префикс *Ok* (по-умолчанию *projects*, значение не может быть *admin*, *cddisk*, *contacts*, *cdmail* или *calendar*)
- Настраивается cddisk "Prefix name for cdmail:" ввести префикс *Ok* (по-умолчанию *cdmail*, значение не может быть *admin*, *contacts*, *cddisk*. *projects* или *calendar*)
- Настраивается cddisk "Prefix name for calendar:" ввести префикс *Ok* (по-умолчанию *calendar*, значение не может быть *admin*, *contacts*, *cdmail*, *projects* или *cddisk*)
- Настраивается cddisk "Prefix name for DS:" ввести префикс *Ok* (по-умолчанию *ds*)
Дождаться завершения установки.

2. Установка cddisk и Document Server на локальную машину, базы данных на удалённую машину.

Внимание! Права доступа Postgresql server на удалённой машине должны быть настроены для создания базы данных.
Если требуется поддержка HTTPS, перед установкой скопируйте crt и key файлы в папку sslcert. Имя файла должно содержать название домена и расширение.
Если требуется выполнить чистую установку, то в диалоге
- Настраивается cddisk "Make clean install?": Выбрать Да (Yes)
Если не требуется выполнить чистую установку, то в диалоге
- Настраивается cddisk "Make clean install?": Выбрать Нет (No)
- Настраивается cddisk "Install postgresql on local pc?": Выбрать Нет (No)
- Настраивается cddisk "Install Document Server?": Выбрать Да (Yes)
- Настраивается cddisk "Document Server secret:" ввести секретный ключ, выбрать *Ok*
- Настраивается cddisk "Document Server Database password:" ввести **saSA123$**, выбрать *Ok*
- Настраивается cddisk "Install CDDisk api & web?": Выбрать Да (Yes)
- Настраивается cddisk "Create database": Выбрать Да (Yes)
- Настраивается cddisk "Database host": оставить *localhost*, выбрать *Ok*
- Настраивается cddisk "Database port": оставить *5432*, выбрать *Ok*
- Настраивается cddisk "Database name": оставить *cddisk*, выбрать *Ok*
- Настраивается cddisk "Database user for create DB": оставить *postgres*, выбрать *Ok*
- Настраивается cddisk "Database password for create DB:", ввести **saSA123$**, выбрать *Ok*
- Настраивается cddisk "Database password for user:", ввести **saSA123$**, выбрать *Ok*
- Настраивается cddisk "The salt to be used during the key derivation process:" ввести ключ, который будет использоваться для генерации хэшей паролей *Ok* (по-умолчанию *Vskoproizvolny Salt par Chivreski_*)
- Настраивается cddisk "Make https access to site. Make https?": Выбрать Yes или No
- Настраивается cddisk "Domain name:" ввести имя домена куда устанавливается cddisk *Ok* (по-умолчанию *local.ru*)
- Настраивается cddisk "Prefix name:" ввести префикс *Ok* (по-умолчанию *cddisk*, значение не может быть *admin*, *cdmail* или *calendar*)
- Настраивается cddisk "Prefix name for cddisk:" ввести префикс *Ok* (по-умолчанию *cddisk*, значение не может быть *admin*, *contacts*, *cdmail*, *projects* или *calendar*)
- Настраивается cddisk "Prefix name for admin:" ввести префикс *Ok* (по-умолчанию *admin*, значение не может быть *cddisk*, *contacts*, *cdmail*, *projects* или *calendar*)
- Настраивается cddisk "Prefix name for contacts:" ввести префикс *Ok* (по-умолчанию *contacts*, значение не может быть *admin*, *cddisk*, *cdmail*, *projects* или *calendar*)
- Настраивается cddisk "Prefix name for projects:" ввести префикс *Ok* (по-умолчанию *projects*, значение не может быть *admin*, *cddisk*, *contacts*, *cdmail* или *calendar*)
- Настраивается cddisk "Prefix name for cdmail:" ввести префикс *Ok* (по-умолчанию *cdmail*, значение не может быть *admin*, *contacts*, *cddisk*. *projects* или *calendar*)
- Настраивается cddisk "Prefix name for calendar:" ввести префикс *Ok* (по-умолчанию *calendar*, значение не может быть *admin*, *contacts*, *cdmail*, *projects* или *cddisk*)
- Настраивается cddisk "Prefix name for DS:" ввести префикс *Ok* (по-умолчанию *ds*)
Дождаться завершения установки.

3. Установка cddisk на локальную машину, базы данных на удалённую машину. Document Server установлен на удалённой машине.

Внимание! Права доступа Postgresql server на удалённой машине должны быть настроены для создания базы данных.
Если требуется поддержка HTTPS, перед установкой скопируйте crt и key файлы в папку sslcert. Имя файла должно содержать название домена и расширение.
Если требуется выполнить чистую установку, то в диалоге
- Настраивается cddisk "Make clean install?": Выбрать Да (Yes)
Если не требуется выполнить чистую установку, то в диалоге
- Настраивается cddisk "Make clean install?": Выбрать Нет (No)
- Настраивается cddisk "Install postgresql on local pc?": Выбрать Нет (No)
- Настраивается cddisk "Install Document Server?": Выбрать Нет (No)
- Настраивается cddisk "Document server URL:" ввести URL где установлен Document Server, выбрать *Ok*
- Настраивается cddisk "Document Server JWT key:" ввести секретный ключ установленного Document Server, выбрать *Ok*
- Настраивается cddisk "Install CDDisk api & web?": Выбрать Да (Yes)
- Настраивается cddisk "Create database": Выбрать Да (Yes)
- Настраивается cddisk "Database host": оставить *localhost*, выбрать *Ok*
- Настраивается cddisk "Database port": оставить *5432*, выбрать *Ok*
- Настраивается cddisk "Database name": оставить *cddisk*, выбрать *Ok*
- Настраивается cddisk "Database user for create DB": оставить *postgres*, выбрать *Ok*
- Настраивается cddisk "Database password for create DB:", ввести **saSA123$**, выбрать *Ok*
- Настраивается cddisk "Database password for user:", ввести **saSA123$**, выбрать *Ok*
- Настраивается cddisk "The salt to be used during the key derivation process:" ввести ключ, который будет использоваться для генерации хэшей паролей *Ok* (по-умолчанию *Vskoproizvolny Salt par Chivreski_*)
- Настраивается cddisk "Make https access to site. Make https?": Выбрать Yes или No
- Настраивается cddisk "Domain name:" ввести имя домена куда устанавливается cddisk *Ok* (по-умолчанию *local.ru*)
- Настраивается cddisk "Prefix name:" ввести префикс *Ok* (по-умолчанию *cddisk*, значение не может быть *admin*, *cdmail* или *calendar*)
- Настраивается cddisk "Prefix name for cddisk:" ввести префикс *Ok* (по-умолчанию *cddisk*, значение не может быть *admin*, *contacts*, *cdmail*, *projects* или *calendar*)
- Настраивается cddisk "Prefix name for admin:" ввести префикс *Ok* (по-умолчанию *admin*, значение не может быть *cddisk*, *contacts*, *cdmail*, *projects* или *calendar*)
- Настраивается cddisk "Prefix name for contacts:" ввести префикс *Ok* (по-умолчанию *contacts*, значение не может быть *admin*, *cddisk*, *cdmail*, *projects* или *calendar*)
- Настраивается cddisk "Prefix name for projects:" ввести префикс *Ok* (по-умолчанию *projects*, значение не может быть *admin*, *cddisk*, *contacts*, *cdmail* или *calendar*)
- Настраивается cddisk "Prefix name for cdmail:" ввести префикс *Ok* (по-умолчанию *cdmail*, значение не может быть *admin*, *contacts*, *cddisk*. *projects* или *calendar*)
- Настраивается cddisk "Prefix name for calendar:" ввести префикс *Ok* (по-умолчанию *calendar*, значение не может быть *admin*, *contacts*, *cdmail*, *projects* или *cddisk*)
- Настраивается cddisk "Prefix name for DS:" ввести префикс *Ok* (по-умолчанию *ds*)
Дождаться завершения установки.

4. Установка cddisk на локальную машину, база данных cddisk установлена на удалённую машину, Document Server установлен на удалённую машину.

Внимание! Права доступа Postgresql server на удалённой машине должны быть настроены для создания базы данных.
Если требуется поддержка HTTPS, перед установкой скопируйте crt и key файлы в папку sslcert. Имя файла должно содержать название домена и расширение.
Если требуется выполнить чистую установку, то в диалоге
- Настраивается cddisk "Make clean install?": Выбрать Да (Yes)
Если не требуется выполнить чистую установку, то в диалоге
- Настраивается cddisk "Make clean install?": Выбрать Нет (No)
- Настраивается cddisk "Install postgresql on local pc?": Выбрать Нет (No)
- Настраивается cddisk "Install Document Server?": Выбрать Нет (No)
- Настраивается cddisk "Document server URL:" ввести URL где установлен Document Server, выбрать *Ok*
- Настраивается cddisk "Document Server JWT key:" ввести секретный ключ установленного Document Server, выбрать *Ok*
- Настраивается cddisk "Install CDDisk api & web?": Выбрать Да (Yes)
- Настраивается cddisk "Create database": Выбрать Нет (No)
- Настраивается cddisk "Database host": оставить *localhost*, выбрать *Ok*
- Настраивается cddisk "Database port": оставить *5432*, выбрать *Ok*
- Настраивается cddisk "Database name": оставить *cddisk*, выбрать *Ok*
- Настраивается cddisk "Database user for create DB": оставить *postgres*, выбрать *Ok*
- Настраивается cddisk "Database password for create DB:", ввести **saSA123$**, выбрать *Ok*
- Настраивается cddisk "Database password for user:", ввести **saSA123$**, выбрать *Ok*
- Настраивается cddisk "The salt to be used during the key derivation process:" ввести ключ, который будет использоваться для генерации хэшей паролей *Ok* (по-умолчанию *Vskoproizvolny Salt par Chivreski_*)
- Настраивается cddisk "Make https access to site. Make https?": Выбрать Yes или No
- Настраивается cddisk "Domain name:" ввести имя домена куда устанавливается cddisk *Ok* (по-умолчанию *local.ru*)
- Настраивается cddisk "Prefix name:" ввести префикс *Ok* (по-умолчанию *cddisk*, значение не может быть *admin*, *cdmail* или *calendar*)
- Настраивается cddisk "Prefix name for cddisk:" ввести префикс *Ok* (по-умолчанию *cddisk*, значение не может быть *admin*, *contacts*, *cdmail*, *projects* или *calendar*)
- Настраивается cddisk "Prefix name for admin:" ввести префикс *Ok* (по-умолчанию *admin*, значение не может быть *cddisk*, *contacts*, *cdmail*, *projects* или *calendar*)
- Настраивается cddisk "Prefix name for contacts:" ввести префикс *Ok* (по-умолчанию *contacts*, значение не может быть *admin*, *cddisk*, *cdmail*, *projects* или *calendar*)
- Настраивается cddisk "Prefix name for projects:" ввести префикс *Ok* (по-умолчанию *projects*, значение не может быть *admin*, *cddisk*, *contacts*, *cdmail* или *calendar*)
- Настраивается cddisk "Prefix name for cdmail:" ввести префикс *Ok* (по-умолчанию *cdmail*, значение не может быть *admin*, *contacts*, *cddisk*. *projects* или *calendar*)
- Настраивается cddisk "Prefix name for calendar:" ввести префикс *Ok* (по-умолчанию *calendar*, значение не может быть *admin*, *contacts*, *cdmail*, *projects* или *cddisk*)
- Настраивается cddisk "Prefix name for DS:" ввести префикс *Ok* (по-умолчанию *ds*)
Дождаться завершения установки.
