
DO $$ 
    BEGIN
          IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=1765) THEN
		RETURN;
          END IF;
        BEGIN
        CREATE TABLE public."EmailLabels"
        (
	        "Id" bigserial,
	        "Hash" character varying(64) NOT NULL,
	        "Name" character varying(256) NULL,
	        "Color" character varying(50) NULL,  
	        "OwnerId" BIGINT NULL,
	        "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
                 CONSTRAINT "PK_EmailLabels" PRIMARY KEY("Hash")

        );

CREATE INDEX "IDX_EmailLabels_OwnerId"
    ON public."EmailLabels" USING btree
    ("OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default; 
        EXCEPTION
            WHEN duplicate_table THEN RAISE NOTICE 'Create table <EmailLabels>.';
        END;
    END;
$$


