DO $$ 
    BEGIN
IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=1765) THEN
		RETURN;
          END IF;
        BEGIN
           DROP TABLE IF EXISTS public."CalendarSettings";
CREATE TABLE public."CalendarSettings" (
    "Id" bigserial,
    "CalendarId" bigint NOT NULL,
    "UserId" bigint NOT NULL, 
    "Name" character varying(500) NOT NULL,
    "ImageId" bigint,
    "TimezoneId" INT NULL,
    "Color" character varying(50) NULL,
    "BackColor" character varying(12) NULL, 
    "Status" integer  DEFAULT 1 NOT NULL,
    "IsEnabled" boolean DEFAULT true NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
     PRIMARY KEY ("CalendarId", "UserId")

);
        EXCEPTION
            WHEN duplicate_column THEN RAISE NOTICE 'column TimezoneId already exists in <CalendarSettings>.';
        END;
    END;
$$




