DO $$ 
    BEGIN
          IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=2772) THEN
		RETURN;
          END IF;
        BEGIN

       	 


CREATE TABLE IF NOT EXISTS public."ProjectSprints"
(
    "Id" bigserial NOT NULL,
    "Name" character varying(500) NOT NULL,
    "Description" character varying(3000) ,
    "ProjectId" bigint NOT NULL DEFAULT 0,
    "AuthorId" bigint NOT NULL DEFAULT 0,
    "Status" integer NOT NULL DEFAULT 0,
    "Type" integer NOT NULL DEFAULT 0,
    "StartDate" timestamp without time zone,
    "EndDate" timestamp without time zone,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    CONSTRAINT "ProjectSprints_pkey" PRIMARY KEY ("Id")
);
 

	CREATE INDEX IF NOT EXISTS "IDX_ProjectSprints-ProjectId-AuthorId"
    ON public."ProjectSprints" USING btree
    ("ProjectId" ASC NULLS LAST, "AuthorId" ASC NULLS LAST)
    TABLESPACE pg_default;
 

        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE 'Create table ProjectSprints error.';
        END;
    END;
$$
