DO $$
	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=3428) THEN
			RETURN;
	END IF;

	BEGIN

		
		ALTER  TABLE public."UserAddressBookLinks" ADD "LocalPhone" character varying(25);


		CREATE INDEX "UserAddressBookLinks_IDX_Name"
 		   ON public."UserAddressBookLinks" USING btree
 		   ("AddressBookId" ASC NULLS LAST, "Name" COLLATE pg_catalog."default" ASC NULLS LAST)
 		   TABLESPACE pg_default;

		CREATE INDEX "UserAddressBookLinks_IDX_Id"
  		  ON public."UserAddressBookLinks" USING btree
 		   ("Id" ASC NULLS LAST)
 		   TABLESPACE pg_default;

		EXCEPTION
			WHEN OTHERS THEN RAISE NOTICE 'Add column LocalPhone to table UserAddressBookLinks error.';
		END;
	END;
$$
