DO $$
	DECLARE 
	 path character varying(256) =  'Patch-2024-04-18-Contacts-Login-Copy';
	BEGIN
		
	IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=path) THEN
    			RETURN;
    	END IF;

 
	IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=3780) THEN
			RETURN;
	END IF;

	BEGIN

		ALTER TABLE public."Contacts" ADD "LoginNew" character varying(2048);		
		UPDATE public."Contacts" SET "LoginNew" = "ExternalId";
		ALTER TABLE public."Contacts" DROP "Login";
		ALTER TABLE public."Contacts" RENAME "LoginNew" TO "Login";

		CREATE INDEX "ix_Contacts_Login"
		ON public."Contacts" USING btree
		("Login" COLLATE pg_catalog."default" ASC NULLS LAST)
		TABLESPACE pg_default; 

		INSERT INTO public."Versions" ("Path", "Build")
		select path,0 ;

		EXCEPTION
			WHEN OTHERS THEN RAISE NOTICE 'Alter contacts login field error.';
		END;
	END;
$$
