﻿
DO $$ 
    BEGIN
         IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=3942) THEN
		RETURN;
          END IF;
 
        BEGIN
  
CREATE TABLE IF NOT EXISTS public."Licenses"
(
    "Id" bigserial NOT NULL,
    "InstallationGuid" character varying(1500) NOT NULL,
    "MachineHostname" character varying(4000) NOT NULL,
    "MachineId" character varying(4000) NOT NULL,
    "MachineIp" character varying(4000) NOT NULL,
    "OperatingSystem" character varying(4000) NOT NULL,
    "ProductType" character varying(4000) NOT NULL,
    "SubscriptionId" character varying(4000) NOT NULL,
    "ProductVersion" character varying(4000) NOT NULL,
    "FileName" character varying(4000) NOT NULL,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    "OwnerId" bigint NOT NULL,
    "CustomerId" int not null,
    "Data" text NULL, 
    CONSTRAINT "Licenses_pkey" PRIMARY KEY ("Id")
);
 
 

CREATE INDEX IF NOT EXISTS "IDX_Licenses-CustomerId-OwnerId"
    ON public."Licenses" USING btree
    ("CustomerId" ASC NULLS LAST, "OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default;
        EXCEPTION
            WHEN duplicate_table THEN RAISE NOTICE 'Can not Create table <Licenses>.';
        END;
    END;
$$







