
DO $$ 
    BEGIN
         IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=4011) THEN
		RETURN;
          END IF;
 
        BEGIN
  

CREATE TABLE IF NOT EXISTS public."ProjectTaskLinks"
(
    "Id" bigserial NOT NULL,
    "FromId" bigint NOT NULL,
    "ToId" bigint NOT NULL,
    "Type" int NOT NULL,
    "ProjectId" bigint NOT NULL,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    CONSTRAINT "ProjectTaskLinks_pkey" PRIMARY KEY ("Id")
);
 

CREATE INDEX IF NOT EXISTS "IDX_ProjectTaskLinks-FromId-ToId-ProjectId"
    ON public."ProjectTaskLinks" USING btree
    ("FromId"ASC NULLS LAST,"ToId"ASC NULLS LAST,"ProjectId"ASC NULLS LAST)
    TABLESPACE pg_default; 

 
        EXCEPTION
            WHEN duplicate_table THEN RAISE NOTICE 'Can not Create table <ProjectTaskLinks>.';
        END;
    END;
$$









