DO $$
	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=3477) THEN
			RETURN;
	END IF;

	BEGIN

		DROP TABLE public."ProjectStatuses";

		CREATE TABLE IF NOT EXISTS public."ProjectStatuses"
(
    "Id" bigserial NOT NULL,
    "Name" character varying(200) NOT NULL,
    "Color" character varying(12) NOT NULL,
    "Type" integer NOT NULL,
    "Icon" character varying(128) NULL,
    "ImageId" BIGINT NULL,
    "EntityId" BIGINT NULL, 
    "EntityType" BIGINT NOT NULL, 
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    CONSTRAINT "ProjectStatuses_pkey" PRIMARY KEY ("Id")
);


		EXCEPTION
			WHEN OTHERS THEN RAISE NOTICE 'Add   table ProjectStatuses error.';
		END;
	END;
$$
