DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-06-17-License-StartDate';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=4134) THEN
			RETURN;
		END IF;

		BEGIN

		ALTER TABLE  public."Licenses" ADD "Connections" int null;
    		ALTER TABLE  public."Licenses" ADD "StartDate" timestamp without time zone;
    		ALTER TABLE  public."Licenses" ADD "EndDate" timestamp without time zone;
    		ALTER TABLE  public."Licenses" ADD "Key" character varying(1500) NULL;

			CREATE INDEX IF NOT EXISTS "IDX_Licenses-Key-EndDate-MachineId"
    				ON public."Licenses" USING btree
    				("Key" ASC NULLS LAST, "EndDate" ASC NULLS LAST, "MachineId" ASC NULLS LAST)
    				TABLESPACE pg_default;

		INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-06-17-License-StartDate: %', SQLERRM;
		END;
	END;
$$
