DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-08-21-EmailAttachments-FileNameSize';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=4390) THEN
			RETURN;
		END IF;

		BEGIN
		ALTER TABLE public."EmailAttachments" ADD "FileNameNew" character varying(4000);
		UPDATE public."EmailAttachments" SET "FileNameNew" = "FileName";
		ALTER TABLE public."EmailAttachments" DROP "FileName";
		ALTER TABLE public."EmailAttachments" RENAME "FileNameNew" TO "FileName";

 
		INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-08-21-EmailAttachments-FileNameSize: %', SQLERRM;
		END;
	END;
$$
