DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-09-03-EmailMessages-MessageId';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=4490) THEN
			RETURN;
		END IF;

		BEGIN
		ALTER TABLE public."EmailMessages" ADD "MessageIdNew" character varying(1024);
		UPDATE public."EmailMessages" SET "MessageIdNew" = "MessageId";
		ALTER TABLE public."EmailMessages" DROP "MessageId";
		ALTER TABLE public."EmailMessages" RENAME "MessageIdNew" TO "MessageId";
		
		CREATE INDEX "IDX_EmailMessages_MessageId_Id"
   			 ON public."EmailMessages" USING btree
   			 ("MessageId" ASC NULLS LAST,"Id" ASC NULLS LAST)
    			TABLESPACE pg_default; 
 
		INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-09-03-EmailMessages-MessageId: %', SQLERRM;
		END;
	END;
$$