DO $$ 
	DECLARE _path character varying(256) = 'patch-2024_09_20_QuotaEntityRelations';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=4230) THEN
			RETURN;
		END IF;

		BEGIN

CREATE TABLE IF NOT EXISTS public."QuotaEntityRelations" (
   "Id" bigserial NOT NULL,
   "QuotaId" integer NOT NULL,
   "EntityId" bigint NOT NULL,
   "EntityType" integer NOT NULL,
   "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    PRIMARY KEY ("QuotaId", "EntityType", "EntityId")
    );

CREATE INDEX IF NOT EXISTS "IDX_QuotaEntityRelations_EntityId-EntityType-OwnerId"
    ON public."QuotaEntityRelations" USING btree
    ("EntityId" ASC NULLS LAST,"EntityType" ASC NULLS LAST,"QuotaId" ASC NULLS LAST)
    TABLESPACE pg_default;


			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-07-18-Licenses_UIndex: %', SQLERRM;
		END;
	END;
$$



