DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-10-08-IDX_DocumentDirectories_Id';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14485) THEN
			RETURN;
		END IF;

		BEGIN
			CREATE INDEX "IDX_DocumentDirectories_Id"
    				ON public."DocumentDirectories" USING btree
    				("Id" ASC NULLS LAST)
    				TABLESPACE pg_default;  
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-10-08-IDX_DocumentDirectories_Id: %', SQLERRM;
		END;
	END;
$$