DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-12-17-DocumentDirectoriesIndex';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14552) THEN
			RETURN;
		END IF;

		BEGIN
			CREATE INDEX "IDX_DocumentDirectories_CustomerId-OwnerId"
    ON public."DocumentDirectories" USING btree
    ("CustomerId" ASC NULLS LAST, "OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default;  

 
 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-12-17-DocumentDirectoriesIndex: %', SQLERRM;
		END;
	END;
$$ 