DO $$ 
	DECLARE _path character varying(256) = 'patch-2025-05-19-Notifications_recreate';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14979) THEN
			RETURN;
		END IF;

		BEGIN
		
			DROP TABLE public."Notifications";
			CREATE TABLE public."Notifications" (
				"Id" bigserial PRIMARY KEY,
				"Date" timestamp without time zone,
				"SourceUserId" bigint NULL,
				"SourceUserName" character varying(128) NULL,
				"Source" integer DEFAULT 0 NOT NULL,
				"Type" integer DEFAULT 0 NOT NULL,
				"Json" character varying NOT NULL,
				"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
			);

			CREATE INDEX "IDX_Notifications_Id" ON public."Notifications" USING btree ("Id");

			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
           EXCEPTION
			WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025-05-19-Notifications_recreate: %', SQLERRM;
		END;
	END;
$$