﻿DO $$
DECLARE 
    _path character varying(256) := 'patch-2025-07-16-ProjectSettings';
BEGIN
    IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path" = _path) THEN
        RETURN;
    END IF;

    IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build" >= 15188) THEN
        RETURN;
    END IF;

    BEGIN
        CREATE TABLE IF NOT EXISTS public."ProjectSettings"
	      (
		        "ProjectId" bigint PRIMARY KEY,
		        "FeaturesJson" text NOT NULL,
		        "UpdatedAt" timestamp with time zone NOT NULL DEFAULT now()
	      );

        	INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
    END;
END;
$$;