DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_03_19-StorageConfigurations';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15123) THEN
			RETURN;
		END IF;

		BEGIN

           CREATE TABLE IF NOT EXISTS public."StorageConfigurations" (
    "Id" bigserial PRIMARY KEY,
    "Status" integer DEFAULT 0 NOT NULL,
    "Type" integer DEFAULT 0 NOT NULL,
    "Name" character varying(2000) NOT NULL,
    "Json" text,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
);


 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025_03_19-StorageConfigurations: %', SQLERRM;
		END;
	END;
$$