DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_04_22-ProjectsCretedAt';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14908) THEN
			RETURN;
		END IF;

		BEGIN
            		ALTER TABLE public."Projects" ADD "Updated" timestamp without time zone;
            		ALTER TABLE public."ProjectSprints" ADD "Updated" timestamp without time zone; 
            		update public."ProjectSprints" SET "Updated"="Timestamp";
            		update public."Projects" SET "Updated"="Timestamp";

 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025_04_22-ProjectsCretedAt: %', SQLERRM;
		END;
	END;
$$