DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_04_23-UserActions-EntityId';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14914) THEN
			RETURN;
		END IF;

		BEGIN
			ALTER TABLE public."UserActions" ADD "EntityId" bigint NULL;

			CREATE INDEX "UserActions_IDX_EntityId-EntityType"
 				   ON public."UserActions" USING btree
    				("EntityId" ASC NULLS LAST, "EntityType" ASC NULLS LAST)
    				TABLESPACE pg_default;

			CREATE INDEX "UserActions_IDX_UserId-Date"
    				ON public."UserActions" USING btree
    				("UserId" ASC NULLS LAST, "Date" ASC NULLS LAST)
    				TABLESPACE pg_default;


 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025_04_23-UserActions-EntityId: %', SQLERRM;
		END;
	END;
$$