DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_05_14-DiskAccessRoleViewDefaults';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14965) THEN
			RETURN;
		END IF;

		BEGIN

			INSERT INTO public."RoleAccessRights"("RoleId", "EntityId", "EntityType", "Type", "OwnerId")
			SELECT r."Id", ar."Id", 34, 0, 0 FROM public."Roles" r
			JOIN public."Roles" ar on r."CustomerId" = ar."CustomerId"
			WHERE r."Type" = 4 AND r."CustomerId" <> -1 AND NOT EXISTS(SELECT "RoleId" FROM public."RoleAccessRights" rar
							WHERE rar."RoleId" = r."Id"
							AND rar."EntityId" = ar."Id"
							AND rar."EntityType" = 34);

			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025_05_14-DiskAccessRoleViewDefaults: %', SQLERRM;


		END;
	END;
$$