DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_06_12-FlexibleFieldFloat';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15113) THEN
			RETURN;
		END IF;

		BEGIN
            		CREATE TABLE public."FlexibleFieldFloat" (
    "Id" bigserial,
    "TableId" bigint NOT NULL,
    "FieldId" bigint NOT NULL,
    "EntityId" bigint NOT NULL,
    "Value" double precision,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    CONSTRAINT "FlexibleFieldFloat_pkey" PRIMARY KEY ("FieldId","EntityId")
);
CREATE INDEX IF NOT EXISTS "IDX_FlexibleFieldFloat-TableId"
    ON public."FlexibleFieldFloat" USING btree
    ("TableId" ASC NULLS LAST)
    TABLESPACE pg_default;
			
 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025_06_12-FlexibleFieldFloat: %', SQLERRM;
		END;
	END;
$$



