DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_06_12-FlexibleTableEntity';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15113) THEN
			RETURN;
		END IF;

		BEGIN
            		
CREATE TABLE public."FlexibleTableEntity" (
    "Id" bigserial PRIMARY KEY,
    "TableId" bigint NOT NULL,
    "Updated" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
);

CREATE INDEX IF NOT EXISTS "IDX_FlexibleTableEntity-TableId"
    ON public."FlexibleTableEntity" USING btree
    ("TableId" ASC NULLS LAST)
    TABLESPACE pg_default;
			
 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025_06_12-FlexibleTableEntity: %', SQLERRM;
		END;
	END;
$$