DO $$
    DECLARE _path character varying(256) = 'patch-2025_09_24-ProjectStatuses';

    BEGIN
        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
            RETURN;
        END IF;

        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15356) THEN
            RETURN;
        END IF;

        BEGIN

	UPDATE public."ProjectStatuses" SET "Color"='gray.8' WHERE "Type" = 5 and "EntityId" is null;

            INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
            EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
        END;
    END;
$$