DO $$
    DECLARE _path character varying(256) = 'patch-2025_09_30-ProjectFlexibleTableLinks';
    BEGIN
        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
            RETURN;
        END IF;

        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build" >= 15419) THEN
            RETURN;
        END IF;

        BEGIN
            CREATE TABLE IF NOT EXISTS public."ProjectFlexibleTableLinks" (
                "Id" bigserial NOT NULL,
	
	"ProjectId" bigint NOT NULL,
	"TableId" bigint NOT NULL,
	"OwnerId" bigint NOT NULL,
	
	"AccessType" int4 NOT NULL,
	
	"Timestamp" timestamp DEFAULT timezone('utc'::text, now()) NOT NULL,
	CONSTRAINT "ProjectFlexibleTableLinks_pkey" PRIMARY KEY ("ProjectId", "TableId")
            );

            CREATE INDEX IF NOT EXISTS "IDX_ProjectFlexibleTableLinks-Id" ON public."ProjectFlexibleTableLinks" USING btree ("Id");

            INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
        END;
    END;
$$;