DO $$
    DECLARE _path character varying(256) = 'patch-2025_10_04-ProjectTaskUserPerformer';
    BEGIN
        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
            RETURN;
        END IF;

        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build" >= 15440) THEN
            RETURN;
        END IF;

        BEGIN
        	
           ALTER TABLE public."ProjectTaskUserPerformer"  ADD "ProjectId" bigint NULL;

           CREATE INDEX IF NOT EXISTS "IDX_ProjectTaskUserPerformer_ProjectId" ON public."ProjectTaskUserPerformer" USING btree ("ProjectId");

	   UPDATE public."ProjectTaskUserPerformer" SET "ProjectId"=(SELECT pt."ProjectId" FROM public."ProjectTasks" pt WHERE pt."Id"=public."ProjectTaskUserPerformer"."TaskId" LIMIT 1);



            INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
        END;
    END;
$$;