﻿DO $$
    DECLARE _path character varying(256) = 'patch-2025_10_21-FilesEncryption';
    BEGIN
        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path" = _path) THEN
            RETURN;
        END IF;
        
                IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build" >= 15510) THEN
                    RETURN;
        END IF;
        
        BEGIN
        ALTER TABLE public."Files"
            ADD COLUMN IF NOT EXISTS "IsEncrypted" boolean NOT NULL DEFAULT false;
        
        INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
        EXCEPTION
                    WHEN OTHERS THEN RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
        END;
    END;
$$;