DO $$
    DECLARE _path character varying(256) = 'patch-2025_10_23-ProjectTaskType';
    BEGIN
        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
            RETURN;
        END IF;

        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build" >= 15528) THEN
            RETURN;
        END IF;

        BEGIN
	
	drop INDEX IF EXISTS "IDX_ProjectTaskTypes-ProjectId-Name";

	CREATE UNIQUE INDEX IF NOT EXISTS "IDX_ProjectTaskTypes-ProjectId-Name"
    ON public."ProjectTaskTypes" USING btree
    ("ProjectId" ASC NULLS LAST, "Name" ASC NULLS LAST) 
    TABLESPACE pg_default
	where "IsDeleted" = false;

            INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
        END;
    END;
$$;