﻿DO $$
DECLARE
    _path character varying(256) := 'patch-2025_10_28-EventDetailsStatus';
BEGIN
    IF EXISTS (SELECT 1 FROM public."Versions" WHERE "Path" = _path) THEN
        RETURN;
    END IF;
    
    IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build" >= 15536) THEN
            RETURN;
    END IF;

    BEGIN
        PERFORM 1
        FROM information_schema.columns
        WHERE table_schema = 'public'
          AND table_name = 'EventDetails'
          AND column_name = 'Status';
        IF NOT FOUND THEN
            EXECUTE 'ALTER TABLE public."EventDetails" ADD COLUMN "Status" integer NOT NULL DEFAULT 0';
        END IF;

        PERFORM 1
        FROM information_schema.columns
        WHERE table_schema = 'public'
          AND table_name = 'EventDetails'
          AND column_name = 'CancelledAt';
        IF NOT FOUND THEN
            EXECUTE 'ALTER TABLE public."EventDetails" ADD COLUMN "CancelledAt" timestamp without time zone NULL';
        END IF;

        INSERT INTO public."Versions" ("Path","Build") VALUES (_path, 0);

    EXCEPTION
        WHEN OTHERS THEN 
            RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
    END;
END;
$$;