﻿DO $$
    DECLARE
        _path character varying(256) := 'patch-2025_12_12-UserAddressBooksAddUid';
    BEGIN
        IF EXISTS (SELECT 1 FROM public."Versions" WHERE "Path" = _path) THEN
            RETURN;
        END IF;

        IF EXISTS (SELECT 1 FROM public."Versions" WHERE "Build" >= 15813) THEN
            RETURN;
        END IF;

        BEGIN
 
            ALTER TABLE public."UserAddressBooks" ADD COLUMN IF NOT EXISTS "Uid" character varying(256);

	   CREATE INDEX IF NOT EXISTS "IDX_UserAddressBooks-Uid-OwnerId"
    	ON public."UserAddressBooks" USING btree
    	("Uid" ASC NULLS LAST,"OwnerId" ASC NULLS LAST)
    	TABLESPACE pg_default;




 	CREATE INDEX IF NOT EXISTS "IDX_UserAddressBooks-OwnerId"
    	ON public."UserAddressBooks" USING btree
    	("OwnerId" ASC NULLS LAST)
    	TABLESPACE pg_default;

	update public."UserAddressBooks" SET "Uid"="Id"::text;

            INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

        EXCEPTION
            WHEN OTHERS THEN
                RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
        END;

    END;
$$;