INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('UserActionMessages.Localization','{
    "Types": {
        "UserLogin": "Успешная авторизация через Api",
        "AuthError": "Неудачная попытка авторизации через Api",
        "Logout": "Выход из системы",
        "AddDocument": "Создание документа {0} в папке {1}",
		"AddDocumentLabel": "Создание ярлыка на документ {0} в папке {1}",
        "DeleteDocument": "Удаление документа {0} из папки {1}",
        "DeleteTrashDocument": "Удаление документа {0} из корзины",
        "DeleteGlobalTrashDocument": "Удаление документа {0} из глобальной корзины",
		"DeleteDocumentLabel": "Удаления ярлыка документа {0} из папки",
        "DeleteCalendar": "Удаление календаря {0}",
        "AddFavoriteContact": "Добавление в изранное контакта {0}",
        "AddFavoriteDocument": "Добавление в изранное документа {0}",
        "AddLink": "Создание ссылки на {0} {1}",
        "AddExternalLink": "Создание внешней ссылки на {0} {1}",
        "DownloadDocument": "Скачивание документа {0}",
        "UploadDocument": "Загрузка документа {0} в папку {1}",
        "DownloadDocumentByLink": "Скачивание документа {0} по ссылке",
        "DocumentOpen": "Открытие документа {0} по внутренней ссылке",
        "DocumentOpenUid": "Открытие документа {0} по внешней ссылке",
        "DocumentEdit": "Редактирование документа {0}",
		"ChangeDocumentVersion": "Изменение версии документа {0} c {1} на {2}",
        "EntityShareEvent": "Предоставлен доступ к событию {0} для {1}",
        "EntityShareCalendar": "Предоставлен доступ к календарям {0} для {1}",
        "EntityShareProjects": "Предоставлен доступ к проектам {0} для {1}",
        "DocumentShare": "Предоставлен доступ к документу {0} для {1}",
		"UnEntityShareDocument": "Снятие доступа к документу {0} для {1}",
        "EntityShareDirectory": "Предоставлен доступа к папке {0} для {1}",
		"UnEntityShareDirectory": "Снятие доступа к папке {0} для {1}",
        "DeleteDirectory": "Удаление папки {0} из папки {1}",
		"DeleteTrashDirectory": "Удаление папки {0} из Корзины",
		"DeleteGlobalTrashDirectory": "Удаление папки {0} из Глобальной Корзины",
		"RenameDirectory": "Изменение имени папки {0} на {1}",
		"RenameDocument": "Изменение имени документа {0} на {1}",
        "DeleteEvent": "Удаление события {0}",
        "GetDocuments": "Получение списка документов папки {0}",
        "RestoreDirectory": "Восстановление папки {0} в папку {1}",
        "MoveDocument": "Перемещение документа {0} из папки {1} в папку {2}",
		"MoveDirectory": "Перемещение папки {0} из папки {1} в папку {2}",
        "DeleteUser": "Удаление пользователя {0}",
        "DeleteUserWithTransfer": "Удаление пользователя {0} с переносом документов пользователю {1}",
		"ChangeTokenDuration": "Изменение настроек времени существования токена",
		"PasswordEnterCount": "Изменение настроек ограничения попыток ввода пароля",
		"UserIpWhiteList": "Изменение настроек IP-безопасности пользователей",
		"AdminIpWhiteList": "Изменение настроек IP-безопасности администрирования",
		"ChangeLdapSettings": "Изменение настроек метода аутентификации",
		"AddDirectory": "Создание папки {0} в папке {1}",
		"CopyDocument": "Копирование документа {0} под именем {1} в папку {2}",
		"CopyDirectory": "Копирование папки {0} в папку {1}",
		"RestoreDocument": "Восстановление файла {0} в папку {1}",
		"ZipDirectory": "Создание архива {0} папки {1} в папку {2}",
		"ZipDocument": "Создание архива {0} документа {1} в папку {2}",
		"UnZipDocument": "Распаковка архива {0} в папку {1}",
		"UnZipFromTheArchiveDocument": "Папка {0} распакована из архива {1}",
		"UnZipFromTheArchiveDirectory": "Документ {0} распакован из архива {1}",
        "AddEvent": "Создание события {0}",
	"DirectoryOpenUid": "Папка {0} открыта по внешней ссылке",
	"AddProjectFlexibleTableLink": "Создана ссылка в проекте {0} на таблицу {1}",
	"ChangeProjectFlexibleTableLink": "Изменена ссылка в проекте {0} на таблицу {1}",
	"RemoveProjectFlexibleTableLink": "Удалена ссылка в проекте {0} на таблицу {1}"
    }
}','ru')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('UserActionMessages.Localization','{
    "Types": {
        "UserLogin": "Successful authorization via Api",
        "AuthError": "Failed authorization attempt via Api",
        "Logout": "Log out of the system",
        "AddDocument": "Creating a document {0} in folder {1}",
		"AddDocumentLabel": "Creating a label to document {0} in folder {1}",
        "DeleteDocument": "Deleting document {0} from folder {1}",
        "DeleteTrashDocument": "Deleting document {0} from the trash",
        "DeleteGlobalTrashDocument": "Deleting document {0} from the global trash",
		"DeleteDocumentLabel": "Deleting document label {0} from folder {1}",
        "DeleteCalendar": "Calendar deletion {0}",
        "AddFavoriteContact": "Adding a contact to the wounded {0}",
        "AddFavoriteDocument": "Adding a damaged document {0}",
        "AddLink": "Creating a link to {0} {1}",
        "AddExternalLink": "Creating an external link to {0} {1}",
        "DownloadDocument": "Downloading a document {0}",
        "UploadDocument": "Uploading a document {0} to folder {1}",
        "DownloadDocumentByLink": "Downloading the document {0} from the link",
        "DocumentOpen": "Opening a document {0} via an internal link",
        "DocumentOpenUid": "Opening a document {0} via an external link",
        "DocumentEdit": "Document editing {0}",
		"ChangeDocumentVersion": "Changing the document version {0} from {1} to {2}",
        "EntityShareEvent": "Granted access to event {0} for {1}",
        "EntityShareCalendar": "Granted access to calendars {0} for {1}",
        "EntityShareProjects": "Granted access to projects {0} for {1}",
        "DocumentShare": "Granted access to document {0} for {1}",
		"UnEntityShareDocument": "Removing access to document {0} for {1}",
        "EntityShareDirectory": "Granted access to directory {0} for {1}",
		"UnEntityShareDirectory": "Removing access to directory {0} for {1}",
		"DeleteDirectory": "Deleting a folder {0} from folder {1}",
		"DeleteTrashDirectory": "Deleting a folder {0} from the Trash",
		"DeleteGlobalTrashDirectory": "Deleting a folder {0} from the Global Trash",
		"RenameDirectory": "Changing the folder name {0} to {1}",
		"RenameDocument": "Changing the document name {0} to {1}",
        "DeleteEvent": "Deleting an event {0}",
        "GetDocuments": "Getting a list of documents in folder {0}",
        "RestoreDirectory": "Restoring folder {0} to folder {1}",
        "MoveDocument": "Moving a document {0} from folder {1} to folder {2}",
		"MoveDirectory": "Moving a directory {0} from folder {1} to folder {2}",
        "DeleteUser": "Deleting a user {0}",
        "DeleteUserWithTransfer": "Deleting user {0} with transferring documents to user {1}",
		"ChangeTokenDuration": "Changing the token lifetime settings",
		"PasswordEnterCount": "Changing the settings for limiting password entry attempts",
		"UserIpWhiteList": "Changing User IP Security settings",
		"AdminIpWhiteList": "Changing the administration IP security settings",
		"ChangeLdapSettings": "Changing the authentication method settings",
		"AddDirectory": "Create directory {0} in {1}",
		"CopyDocument": "Copying document {0} under the name {1} to folder {2}",
		"CopyDirectory": "Copy directory {0} to directory {1}",
		"RestoreDocument": "Restore document {0} to folder {1}",
		"ZipDirectory": "Creating an archive of {0} folder {1} in folder {2}",
		"ZipDocument": "Creating an archive of {0} document {1} in folder {2}",
		"UnZipDocument": "Unpack archive {0} to directory {1}",
		"UnZipFromTheArchiveDocument":"Folder {0} unpacked from archive {1}",
		"UnZipFromTheArchiveDirectory": "Directory {0} unpacked from archive {1}",
        "AddEvent": "Adding an event {0}",
	"DirectoryOpenUid": "Opening a directory {0} via an external link",
	"AddProjectFlexibleTableLink": "Creating a link from {0} project to {1} table",
	"ChangeProjectFlexibleTableLink": "Changing a link from {0} project to {1} table",
	"RemoveProjectFlexibleTableLink": "Removing a link from {0} project to {1} table"
    }
}','en')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";


INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventUpdate.Subject','Обновление события','')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventUpdate.Subject','Event update','en')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInvitation.Subject','Приглашение на событие','')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInvitation.Subject','Invitation to the event','en')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventUpdate.Body','Событие {0} было обновлено.','')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventUpdate.Body','Event {0} has been updated.','en')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInvitation.Body','Пользователь {0} пригласил Вас на событие {1}.','')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInvitation.Body','User {0} invited you to the event {1}.','en')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventCancel.Subject','Отмена события','')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventCancel.Subject','Event cancel','en')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventCancel.Body','Пользователь {0} отменил событие {1}.','')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventCancel.Body','User {0} cancelled event {1}.','en')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";


INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteAccept.Subject','Приглашение на \"{0}\" принято','')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteAccept.Subject','Invitation to \"{0}\" accepted','en')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteAccept.Body','Пользователь {0} подтвердил участие в событии \"{1}\".\nНачало события: {2}','')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteAccept.Body','User {0} has confirmed participation in the \"{1}\" event.\nThe beginning of the event: {2}','en')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";


INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteDeclin.Subject','Приглашение на \"{0}\" отклонено','')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteDeclin.Subject','Invitation to \"{0}\" declined','en')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteDeclin.Body','Пользователь {0} отказался от участия в событии \"{1}\".\nНачало события: {2}','')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteDeclin.Body','User {0} declined to participate in the \"{1}\" event.\nThe beginning of the event: {2}','en')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";


INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteTentative.Subject','Участие в \"{0}\" под вопросом','')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteTentative.Subject','Participation in \"{0}\" is questionable','en')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteTentative.Body','Пользователь {0} ответил \"может быть\" на приглашение в событие \"{1}\".\nНачало события: {2}','')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key",  "Value", "Lang") VALUES ('Notification.EventInviteTentative.Body','User {0} replied \"maybe\" to the invitation to the event \"{1}\".\nThe beginning of the event: {2}','en')
ON CONFLICT ("Key","Lang") DO UPDATE SET "Value"= EXCLUDED."Value";
