INSERT INTO public."MessageSettings"("Key", "Value", "Lang")
VALUES (
  'TelegramNotificationTemplates',
  $$
{
  "documentShare": {
    "title": "Доступ к файлу предоставлен",
    "description": "Теперь у вас есть доступ уровня <b>«{{action.accessType.title}}»</b> к файлу <b>«{{action.subject}}»</b>."
  },
  "documentComment": {
    "title": "Новый комментарий к файлу",
    "description": "<b>{{actor}}</b> оставил новый комментарий к файлу <b>«{{action.subject}}»</b>."
  },
  "documentMention": {
    "title": "Вас упомянули в комментарии",
    "description": "<b>{{actor}}</b> упомянул вас в комментарии к файлу <b>«{{action.subject}}»</b>."
  },
  "directoryShare": {
    "title": "Доступ к папке предоставлен",
    "description": "Теперь у вас есть доступ уровня <b>«{{action.accessType.title}}»</b> к папке <b>«{{action.subject}}»</b>."
  },
  "projectShare": {
    "title": "Доступ к проекту предоставлен",
    "description": "Теперь у вас есть доступ уровня <b>«{{action.accessType.title}}»</b> к проекту <b>«{{action.subject}}»</b>."
  },
  "roleAssigned": {
    "title": "Вам назначена новая роль",
    "description": "Вам назначена роль <b>«{{action.subject}}»</b> в проекте <b>«{{action.customerName}}»</b>."
  },
  "roleDeleted": {
    "title": "Ваша роль удалена",
    "description": "Вас удалили из роли <b>«{{action.subject}}»</b> в проекте <b>«{{action.customerName}}»</b>."
  },
  "taskCreated": {
    "title": "Новая задача создана",
    "description": "<b>{{actor}}</b> создал(а) новую задачу <b>«{{action.title}}»</b>."
  },
  "taskDeleted": {
    "title": "Задача удалена",
    "description": "<b>{{actor}}</b> удалил задачу <b>«{{action.title}}»</b>."
  },
  "taskUpdated": {
    "title": "Детали задачи обновлены",
    "description": "<b>{{actor}}</b> обновил(а) задачу <b>«{{action.title}}»</b>."
  },
  "taskMoved": {
    "title": "Задача перемещена",
    "description": "<b>{{actor}}</b> переместил(а) задачу <b>«{{action.title}}»</b> в <b>«{{action.movedTo}}»</b>."
  },
  "taskStatusChanged": {
    "title": "Статус задачи изменен",
    "description": "<b>{{actor}}</b> переместил(а) задачу <b>«{{action.title}}»</b> в статус <b>«{{action.status}}»</b>."
  },
  "taskCommentAdded": {
    "title": "Новый комментарий к задаче",
    "description": "<b>{{actor}}</b> оставил(а) новый комментарий к задаче <b>«{{action.title}}»</b>."
  },
  "myTaskDeleted": {
    "title": "Задача удалена",
    "description": "<b>{{actor}}</b> удалил задачу <b>«{{action.title}}»</b>."
  },
  "myTaskUpdated": {
    "title": "Детали задачи обновлены",
    "description": "<b>{{actor}}</b> обновил(а) задачу <b>«{{action.title}}»</b>."
  },
  "myTaskMoved": {
    "title": "Задача перемещена",
    "description": "<b>{{actor}}</b> переместил(а) задачу <b>«{{action.title}}»</b> в <b>«{{action.movedTo}}»</b>."
  },
  "myTaskStatusChanged": {
    "title": "Статус задачи изменен",
    "description": "<b>{{actor}}</b> переместил(а) задачу <b>«{{action.title}}»</b> в статус <b>«{{action.status}}»</b>."
  },
  "myTaskCommentAdded": {
    "title": "Новый комментарий к задаче",
    "description": "<b>{{actor}}</b> оставил(а) новый комментарий к задаче <b>«{{action.title}}»</b>."
  },
  "unassignedFromTask": {
    "title": "Вы исключены из задачи",
    "description": "<b>{{actor}}</b> исключил(а) вас из задачи <b>«{{action.title}}»</b>."
  },
  "assignedToTask": {
    "title": "Вам назначена задача",
    "description": "<b>{{actor}}</b> назначил(а) вас на задачу <b>«{{action.title}}»</b>."
  },
  "taskCommentMention": {
    "title": "Вас упомянули в комментарии",
    "description": "<b>{{actor}}</b> упомянул(а) вас в комментарии к задаче <b>«{{action.title}}»</b>."
  },
  "sprintCreated": {
    "title": "Новый спринт создан",
    "description": "Новый спринт <b>«{{action.subject}}»</b> был создан в проекте <b>«{{action.project}}»</b>."
  },
  "importantNewEmailMessage": {
    "title": "Сообщение с флагом «Важное»",
    "description": "<b>{{actor}}</b> отправил(а) новое сообщение с флагом «Важное»"
  },
  "newEmailMessage": {
    "title": "Новое сообщение",
    "description": "<b>{{actor}}</b> отправил(а) новое сообщение"
  },
  "calendarShare": {
    "title": "Доступ к календарю предоставлен",
    "description": "Теперь у вас есть доступ уровня <b>«{{action.accessType.title}}»</b> к календарю <b>«{{action.subject}}»</b>."
  },
  "calendarEventCancel": {
    "title": "Событие отменено",
    "description": "Событие <b>«{{action.subject}}»</b> было отменено <b>{{actor}}</b>."
  },
  "calendarEventInvite": {
    "title": "Вы приглашены на событие",
    "description": "<b>{{actor}}</b> пригласил(а) вас на событие <b>«{{action.subject}}»</b>."
  },
  "calendarEventChange": {
    "title": "Детали события обновлены",
    "description": "<b>{{actor}}</b> обновил(а) детали события <b>«{{action.subject}}»</b>."
  },
  "calendarUpcomingEvent": {
    "title": "Запланированное событие",
    "description": "Событие <b>«{{action.subject, defaultValue(fallback:Без заголовка)}}»</b> {{action.timeUntilStart, eventStatusDescription}}.",
    "started": "началось",
    "willStartIn": "начнется через"
  },
  "roomShare": {
    "title": "Доступ к комнате предоставлен",
    "description": "Теперь у вас есть доступ уровня <b>«{{action.accessType.title}}»</b> к комнате <b>«{{action.subject}}»</b>."
  },
  "taskAttachmentAdded": {
    "title": "Новое вложение в задаче",
    "description": "<b>{{actor}}</b> добавил(а) новое вложение к задаче <b>«{{action.title}}»</b>."
  }
}
  $$,
  'ru'
)
ON CONFLICT ("Key", "Lang") DO UPDATE
SET "Value" = EXCLUDED."Value";

INSERT INTO public."MessageSettings"("Key", "Value", "Lang")
VALUES (
  'TelegramNotificationTemplates',
  $$
{
  "documentShare": {
    "title": "Access Granted to File",
    "description": "You now have <b>«{{action.accessType.title}}»</b> access to the file <b>«{{action.subject}}»</b>."
  },
  "documentComment": {
    "title": "New Comment on File",
    "description": "<b>{{actor}}</b> left a new comment on the file <b>«{{action.subject}}»</b>."
  },
  "documentMention": {
    "title": "You've Been Mentioned",
    "description": "<b>{{actor}}</b> mentioned you in a comment on the file <b>«{{action.subject}}»</b>."
  },
  "directoryShare": {
    "title": "Access Granted to Folder",
    "description": "You now have <b>«{{action.accessType.title}}»</b> access to the folder <b>«{{action.subject}}»</b>."
  },
  "projectShare": {
    "title": "Access Granted to Project",
    "description": "You now have <b>«{{action.accessType.title}}»</b> access to the project <b>«{{action.subject}}»</b>."
  },
  "roleAssigned": {
    "title": "Assigned a New Role",
    "description": "You have been assigned the role <b>«{{action.subject}}»</b> in <b>«{{action.customerName}}»</b>."
  },
  "roleDeleted": {
    "title": "Role Has Been Removed",
    "description": "You have been removed from the <b>«{{action.subject}}»</b> role in <b>«{{action.customerName}}»</b>."
  },
  "taskCreated": {
    "title": "New Task Created",
    "description": "<b>{{actor}}</b> created a new task <b>«{{action.title}}»</b>."
  },
  "taskDeleted": {
    "title": "Task Deleted",
    "description": "The task <b>«{{action.title}}»</b> was deleted by <b>{{actor}}</b>."
  },
  "taskUpdated": {
    "title": "Task Details Updated",
    "description": "<b>{{actor}}</b> updated the task <b>«{{action.title}}»</b>."
  },
  "taskMoved": {
    "title": "Task Moved",
    "description": "<b>{{actor}}</b> moved the task <b>«{{action.title}}»</b> to <b>«{{action.movedTo}}»</b>."
  },
  "taskStatusChanged": {
    "title": "Task Status Changed",
    "description": "<b>{{actor}}</b> moved the task <b>«{{action.title}}»</b> to <b>«{{action.status}}»</b>."
  },
  "taskCommentAdded": {
    "title": "New Comment on Task",
    "description": "<b>{{actor}}</b> left a new comment on the task <b>«{{action.title}}»</b>."
  },
  "myTaskDeleted": {
    "title": "Task Deleted",
    "description": "The task <b>«{{action.title}}»</b> was deleted by <b>{{actor}}</b>."
  },
  "myTaskUpdated": {
    "title": "Task Details Updated",
    "description": "<b>{{actor}}</b> updated the task <b>«{{action.title}}»</b>."
  },
  "myTaskMoved": {
    "title": "Task Moved",
    "description": "<b>{{actor}}</b> moved the task <b>«{{action.title}}»</b> to <b>«{{action.movedTo}}»</b>."
  },
  "myTaskStatusChanged": {
    "title": "Task Status Changed",
    "description": "<b>{{actor}}</b> moved the task <b>«{{action.title}}»</b> to <b>«{{action.status}}»</b>."
  },
  "myTaskCommentAdded": {
    "title": "New Comment on Task",
    "description": "<b>{{actor}}</b> left a new comment on the task <b>«{{action.title}}»</b>."
  },
  "unassignedFromTask": {
    "title": "Unassigned from Task",
    "description": "<b>{{actor}}</b> unassigned you from the task <b>«{{action.title}}»</b>."
  },
  "assignedToTask": {
    "title": "Assigned a Task",
    "description": "<b>{{actor}}</b> assigned you to the task <b>«{{action.title}}»</b>."
  },
  "taskCommentMention": {
    "title": "You've Been Mentioned",
    "description": "<b>{{actor}}</b> mentioned you in a comment on the task <b>«{{action.title}}»</b>."
  },
  "sprintCreated": {
    "title": "New Sprint Created",
    "description": "A new sprint <b>«{{action.subject}}»</b> has been created in the project <b>«{{action.project}}»</b>."
  },
  "importantNewEmailMessage": {
    "title": "Message with \"Important\" Tag",
    "description": "<b>{{actor}}</b> sent a new message tagged as \"Important\""
  },
  "newEmailMessage": {
    "title": "New Message",
    "description": "<b>{{actor}}</b> sent a new message"
  },
  "calendarShare": {
    "title": "Access Granted to Calendar",
    "description": "You now have <b>«{{action.accessType.title}}»</b> access to the calendar <b>«{{action.subject}}»</b>."
  },
  "calendarEventCancel": {
    "title": "Event Canceled",
    "description": "The event <b>«{{action.subject}}»</b> was canceled by <b>{{actor}}</b>."
  },
  "calendarEventInvite": {
    "title": "Invite to Event",
    "description": "<b>{{actor}}</b> invited you to the event <b>«{{action.subject}}»</b>."
  },
  "calendarEventChange": {
    "title": "Event Details Updated",
    "description": "<b>{{actor}}</b> updated the event <b>«{{action.subject}}»</b>."
  },
  "calendarUpcomingEvent": {
    "title": "Upcoming Event",
    "description": "Event <b>«{{action.subject, defaultValue(fallback:Untitled)}}»</b> {{action.timeUntilStart, eventStatusDescription}}.",
    "started": "started",
    "willStartIn": "will start in"
  },
  "roomShare": {
    "title": "Access Granted to Room",
    "description": "You now have <b>«{{action.accessType.title}}»</b> access to the room <b>«{{action.subject}}»</b>."
  },
  "taskAttachmentAdded": {
    "title": "New Attachment in Task",
    "description": "<b>{{actor}}</b> added a new attachment to the task <b>«{{action.title}}»</b>."
  }
}
  $$,
  'en'
)
ON CONFLICT ("Key", "Lang") DO UPDATE
SET "Value" = EXCLUDED."Value";