CREATE TABLE public."Houses"
(
	"Id" bigserial NOT NULL,
	"ObjectId" BIGINT NOT NULL,
	"ObjectGuid" character varying(64) NOT NULL,
	"Name" character varying(1024) NOT NULL,
	"TypeId" int NOT NULL,
	"PostIndex" character varying(100),
	"IsActual" boolean  NOT NULL,
	"IsActive" boolean NOT NULL,
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
);

CREATE INDEX "IDX_Houses_ObjectId"
    ON public."Houses" USING btree
    ("ObjectId" ASC NULLS LAST)
    TABLESPACE pg_default;