CREATE TABLE public."ChatInvite" (
    "GroupUid" character varying(255) NOT NULL,
    "ContactId" bigint NOT NULL,
    "Invited" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    "OwnerUserId" bigint NOT NULL
); 

CREATE INDEX "ChatInvite_PK_ChatInvite"
    ON public."ChatInvite" USING btree
    ("GroupUid" COLLATE pg_catalog."default" ASC NULLS LAST, "ContactId" ASC NULLS LAST)
    TABLESPACE pg_default;  