CREATE TABLE public."ChatUserRecommendations" (
    "Id" bigserial NOT NULL,
    "OwnerId" bigint NOT NULL,
    "ContactId" bigint NOT NULL,
    "Name" character varying(255) NOT NULL,
    "Enable" boolean DEFAULT true NOT NULL,
    "UserId" bigint,
    "Type" integer DEFAULT 0 NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
     PRIMARY KEY ("OwnerId", "ContactId")
);  

CREATE INDEX "ChatUserRecommendations_IX_FK_ChatUserRecommendations"
    ON public."ChatUserRecommendations" USING btree
    ("UserId" ASC NULLS LAST)
    TABLESPACE pg_default;


CREATE INDEX "ChatUserRecommendations_IX_FK_ChatUserRecommendationsContactId"
    ON public."ChatUserRecommendations" USING btree
    ("ContactId" ASC NULLS LAST)
    TABLESPACE pg_default;


CREATE INDEX "ChatUserRecommendations_IX_FK_ChatUserRecommendationsOwnerId"
    ON public."ChatUserRecommendations" USING btree
    ("OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default;
 