CREATE TABLE public."UserAddressBooks" (
    "Id" bigserial PRIMARY KEY,
    "Name" character varying(500) NOT NULL, 
    "Color" character varying(50) NULL, 
    "OwnerId" bigint NOT NULL,
    "Type" integer DEFAULT 0 NOT NULL, 
    "IsEnabled" boolean DEFAULT true NOT NULL,
    "Uid" character varying(256),
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
);


 CREATE INDEX IF NOT EXISTS "IDX_UserAddressBooks-Uid-OwnerId"
    ON public."UserAddressBooks" USING btree
    ("Uid" ASC NULLS LAST,"OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default;




 CREATE INDEX IF NOT EXISTS "IDX_UserAddressBooks-OwnerId"
    ON public."UserAddressBooks" USING btree
    ("OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default;