CREATE TABLE public."Users" (
	"Id" bigserial NOT NULL,
	"CustomerId" integer NOT NULL,
	"ContactId" bigint,
	"Status" smallint NOT NULL,
	"Login" character varying(150) NOT NULL,
	"PasswordHash" character varying(1024) NOT NULL,
	"Name" character varying NOT NULL,
	"Type" integer DEFAULT 0,
	"PhotoId" bigint,
	"Modified" timestamp without time zone,
	"Gender" integer DEFAULT 0 NOT NULL,
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now()) NOT NULL,
	"Culture" character varying(20) NULL,
	"LoginDate" timestamp without time zone,
	CONSTRAINT "PK_Users" PRIMARY KEY ("Id"),
	CONSTRAINT "UIDX_Users" UNIQUE ("Login")
); 

CREATE INDEX "IDX_Users_ContactId-CustomerId-Type-Status-Gender"
	ON public."Users" USING btree
	("ContactId" ASC NULLS LAST,"CustomerId" ASC NULLS LAST,"Type" ASC NULLS LAST,"Status" ASC NULLS LAST,"Gender" ASC NULLS LAST)
	TABLESPACE pg_default; 

CREATE INDEX "IDX_Users_Id-PhotoId"
	ON public."Users" USING btree
	("Id" ASC NULLS LAST,"PhotoId" ASC NULLS LAST)
	TABLESPACE pg_default; 

CREATE INDEX "IDX_Users_ContactId-Login"
    ON public."Users" USING btree
    ("ContactId" ASC NULLS LAST,"Login" ASC NULLS LAST)
    TABLESPACE pg_default; 