CREATE TABLE public."DocumentDirectories" (
    "Id" bigserial NOT NULL,
    "ParentId" bigint,
    "OwnerId" bigint NOT NULL,
    "AuthorId" bigint NOT NULL,
    "Hash" character varying(64) NOT NULL,
    "Name" character varying(256) NOT NULL,
    "CustomerId" integer NOT NULL,
    "Description" character varying(2000) NOT NULL,
    "Order" integer DEFAULT 0 NOT NULL,
    "Type" integer DEFAULT 0 NOT NULL,
    "IconId" bigint,
    "PatternId" bigint,
    "SendNotification" boolean DEFAULT false NOT NULL,
    "IsDeleted" boolean DEFAULT false,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    "Date" timestamp without time zone NULL,
    "HasRights" boolean DEFAULT false,
    "HasShare" boolean DEFAULT false,
    "Size" bigint,
    "SourceParentId" bigint,
    "Color" character varying(10) NULL, 
    "ExpirationDate" timestamp NULL,
    PRIMARY KEY ("Hash", "OwnerId")
);
 

CREATE INDEX "IDX_DocumentDirectories_ParentId-Id-IsDeleted-HasRights-Type"
    ON public."DocumentDirectories" USING btree
    ("Id" ASC NULLS LAST, "ParentId" ASC NULLS LAST, "Type" ASC NULLS LAST, "HasRights" ASC NULLS LAST, "OwnerId" ASC NULLS LAST, "AuthorId" ASC NULLS LAST, "IsDeleted" ASC NULLS LAST)
    TABLESPACE pg_default;  

CREATE INDEX "IDX_DocumentDirectories_Id"
    ON public."DocumentDirectories" USING btree
    ("Id" ASC NULLS LAST)
    TABLESPACE pg_default;  

CREATE INDEX "IDX_DocumentDirectories_CustomerId-OwnerId"
    ON public."DocumentDirectories" USING btree
    ("CustomerId" ASC NULLS LAST, "OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default;  

CREATE INDEX "IDX_DocumentDirectories_ExpirationDate"
    ON public."DocumentDirectories" USING btree
    ("ExpirationDate" ASC NULLS LAST)
    TABLESPACE pg_default;
