CREATE TABLE public."EmailAttachments"
(
    "Id" bigserial PRIMARY KEY,
    "Hash" character varying(64) NOT NULL,
    "FileId" BIGINT NULL,
    "MessageId" BIGINT NOT NULL,
    "OwnerId" BIGINT NOT NULL,
    "FileName" character varying(4000) NOT NULL,
    "MimeType" character varying(512) NOT NULL,
    "ContentType" character varying(1024) NULL, 
    "Size" BIGINT NULL,
    "Cid" character varying(512) NULL,
	"IsBodyPart" boolean,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
);

CREATE INDEX "IDX_EmailAttachments_Hash"
    ON public."EmailAttachments" USING btree
    ("Hash" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_EmailAttachments_OwnerId"
    ON public."EmailAttachments" USING btree
    ("OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_EmailAttachments_MessageId"
    ON public."EmailAttachments" USING btree
    ("MessageId" ASC NULLS LAST)
    TABLESPACE pg_default; 
