CREATE TABLE public."EmailMessages"
(
    "Id" bigserial, 
    "Subject" text NULL, 
    "From" character varying(1024) NULL,
    "FromAccount" BIGINT NULL, 
    "To" text NULL, 
    "Cc" text NULL, 
    "Bcc" text NULL, 
    "Body" text NULL,
    "HtmlBody" text NULL,
    "FolderId" BIGINT NOT NULL,
    "Labels" character varying(1024) NULL,
    "Uid" BIGINT NOT NULL, 
    "WasRead" boolean DEFAULT false,
    "WasSent" boolean DEFAULT false,
    "WasReplied" boolean DEFAULT false,
    "HasAttachments" boolean DEFAULT false,
    "HasThreadAttachments" boolean DEFAULT false,
    "IsDeleted" boolean DEFAULT false,
    "OwnerId" BIGINT NOT NULL,
    "ParentId" BIGINT NULL,
    "ReplyToId" BIGINT NULL,
    "HasChildren" boolean DEFAULT false,
    "Size" BIGINT NOT NULL,
    "Date" timestamp NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL, 
    "Important" boolean DEFAULT false,
    "MessageId" character varying(1024)  NULL,
    "ThreadId" character varying(256)  NULL,
    "FromDisplayName" character varying(512) NULL,
    "FromAddress" character varying(512) NULL,
    "ThreadCount" INT NULL, 
    CONSTRAINT "PK_EmailMessages" PRIMARY KEY("Id"),
    CONSTRAINT "UIDX_EmailMessages" UNIQUE ("FolderId", "Uid")
);

CREATE INDEX "IDX_EmailMessages_ThreadId_OwnerId"
    ON public."EmailMessages" USING btree
    ("ThreadId" ASC NULLS LAST,"OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_EmailMessages_MessageId_Id"
    ON public."EmailMessages" USING btree
    ("MessageId" ASC NULLS LAST,"Id" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_EmailMessages_ParentId"
    ON public."EmailMessages" USING btree
    ("ParentId" ASC NULLS LAST,"Id" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_EmailMessages_FolderId"
    ON public."EmailMessages" USING btree
    ("FolderId" ASC NULLS LAST,"Size" ASC NULLS LAST)
    TABLESPACE pg_default;  

CREATE INDEX "IDX_EmailMessages_Id"
    ON public."EmailMessages" USING btree
    ("Id" ASC NULLS LAST)
    TABLESPACE pg_default;  

CREATE INDEX "IDX_EmailMessages_WasReplied"
    ON public."EmailMessages" USING btree
    ("WasReplied" ASC NULLS LAST)
    TABLESPACE pg_default;  

CREATE INDEX "IDX_EmailMessages_OwnerId"
    ON public."EmailMessages" USING btree
    ("OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default;  