CREATE TABLE public."EventNotifications" (
    "Id" bigserial,
    "Hash" character varying(64) PRIMARY KEY,
    "Key" character varying(1024),
    "EntityId"  bigint NOT NULL,
    "EntityType" integer DEFAULT 0 NOT NULL,
    "Date" timestamp without time zone,  
    "Status" integer DEFAULT 0 NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
);

CREATE INDEX "IDX_EventNotifications-Date-Id-Status"
    ON public."EventNotifications" USING btree
    ("Date" ASC NULLS LAST, "Id" ASC NULLS LAST, "Status" ASC NULLS LAST)
    TABLESPACE pg_default;  