CREATE TABLE public."EventCategories" (
    "Id" serial CONSTRAINT "PK_EventCategories" PRIMARY KEY,
    "Name" character varying(256) NOT NULL,
    "Color" character varying(50) NULL,
    "Order" integer DEFAULT 0 NOT NULL,
    "IconId" bigint,
    "CustomerId" INT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    "UserId" bigint NULL
);


CREATE INDEX "IDX_EventCategories_UserId-CustomerId"
    ON public."EventCategories" USING btree
    ("UserId" ASC NULLS LAST, "CustomerId" ASC NULLS LAST)
    TABLESPACE pg_default;  
/* DEFAULT EVENT CATEGORIES

ID	Name		Color
--- ----------- -------
0	Не задано	#5994CF
1	Встреча		#835E11
2	Конференция	#824793
3	Совещание	#990B01
4	Поездка		#3C4351
5	Звонок		#4E710A
6	Напоминание	#08898E

DEFAULT EVENT CATEGORIES */




