CREATE TABLE public."EventExceptions" (
    "Id" bigserial PRIMARY KEY,
    "StartDate" timestamp NOT NULL, 
    "EndDate" timestamp NOT NULL,
    "OwnerId" bigint NOT NULL,
    "DetailId" bigint NULL, 
    "FromRecurringId" bigint NOT NULL,
    "Status" integer NOT NULL,
    "LastModificationDate" timestamp without time zone DEFAULT timezone('utc', now()) NOT NULL,
    "Sequence" int DEFAULT 0 NOT NULL
);

CREATE INDEX "IDX_EventExceptions_FromRecurringId"
    ON public."EventExceptions" USING btree
    ("FromRecurringId" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_EventExceptions_OwnerId"
    ON public."EventExceptions" USING btree
    ("OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default;
