CREATE TABLE public."UserEventNotifications" (
    "Id" bigserial PRIMARY KEY,
    "EventId" bigint NOT NULL,
    "OwnerId" bigint NOT NULL,
    "Type" smallint NOT NULL, -- На почту или в колокольчик
    "IntervalType" smallint NOT NULL, -- В каких промежутках считаем минуты, часы, дни и т.д.
    "IntervalCount" bigint NOT NULL, -- Количество едениц, в которых считаем. 2 часа, 30 минут и т.д.
    "BellNotificationsId" bigint NULL, -- Id на уведомления для колокольчика, нужно чтобы мы могли удалять 
    "EventNotificationsId" bigint NULL, -- Id на уведомления для почты
    "NotifyAt" timestamp without time zone NOT NULL, -- Время уведомления для события на весь день
    "Source" smallint NOT NULL, -- Отмечаем, откуда уведомление, из настроек календаря или от пользователя
    "LastModificationDate" timestamp without time zone DEFAULT timezone('utc', now()) NOT NULL,
    "Status" smallint NOT NULL, -- Статус уведомления, по типу обработан, зарегестрирован и т.п.
    "Order" int2 DEFAULT 0 NOT NULL
);

CREATE INDEX "IDX_EventsNotifications_EventId"
    ON public."UserEventNotifications" USING btree
    ("EventId" ASC NULLS LAST)
    TABLESPACE pg_default; 