CREATE TABLE public."FlexibleFieldBigInt" (
    "Id" bigserial,
    "TableId" bigint NOT NULL,
    "FieldId" bigint NOT NULL,
    "EntityId" bigint NOT NULL,
    "Value" bigint NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    CONSTRAINT "FlexibleFieldBigInt_pkey" PRIMARY KEY ("FieldId","EntityId")
);

CREATE INDEX IF NOT EXISTS "IDX_FlexibleFieldBigInt-TableId"
    ON public."FlexibleFieldBigInt" USING btree
    ("TableId" ASC NULLS LAST)
    TABLESPACE pg_default;