CREATE TABLE public."FlexibleFieldDate" (
	"Id" bigserial,
	"TableId" bigint NOT NULL,
	"FieldId" bigint NOT NULL,
	"EntityId" bigint NOT NULL,
	"Value" timestamp without time zone NULL,
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
	CONSTRAINT "FlexibleFieldDate_pkey" PRIMARY KEY ("FieldId","EntityId")
);
CREATE INDEX IF NOT EXISTS "IDX_FlexibleFieldDate-TableId"
	ON public."FlexibleFieldDate" USING btree
	("TableId" ASC NULLS LAST)
	TABLESPACE pg_default;