﻿CREATE TABLE IF NOT EXISTS public."GenericViews"
( 
    "Id" bigserial,
    "Value" text, 
    "EntityId" bigint NULL,
    "Type" character varying(1024),
    "OwnerId" bigint NOT NULL,
    "EntityType" int NOT NULL,
    "Hash" character varying(64) NOT NULL PRIMARY KEY
    
);

CREATE INDEX IF NOT EXISTS "IDX_GenericViews-EntityId-OwnerId-EntityTypes"
    ON public."GenericViews" USING btree
    ("EntityId"ASC NULLS LAST,"OwnerId"ASC NULLS LAST,"EntityType"ASC NULLS LAST,"Type"ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE UNIQUE INDEX IF NOT EXISTS "IDX_GenericViews-Id"
    ON public."GenericViews" USING btree
    ("Id"ASC NULLS LAST)
    TABLESPACE pg_default; 